/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.io.OrdinateFormat;

public class CoordinateSequences {
    public static void reverse(CoordinateSequence seq2) {
        if (seq2.size() <= 1) {
            return;
        }
        int last = seq2.size() - 1;
        int mid = last / 2;
        for (int i = 0; i <= mid; ++i) {
            CoordinateSequences.swap(seq2, i, last - i);
        }
    }

    public static void swap(CoordinateSequence seq2, int i, int j) {
        if (i == j) {
            return;
        }
        for (int dim = 0; dim < seq2.getDimension(); ++dim) {
            double tmp = seq2.getOrdinate(i, dim);
            seq2.setOrdinate(i, dim, seq2.getOrdinate(j, dim));
            seq2.setOrdinate(j, dim, tmp);
        }
    }

    public static void copy(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            CoordinateSequences.copyCoord(src, srcPos + i, dest, destPos + i);
        }
    }

    public static void copyCoord(CoordinateSequence src, int srcPos, CoordinateSequence dest, int destPos) {
        int minDim = Math.min(src.getDimension(), dest.getDimension());
        for (int dim = 0; dim < minDim; ++dim) {
            dest.setOrdinate(destPos, dim, src.getOrdinate(srcPos, dim));
        }
    }

    public static boolean isRing(CoordinateSequence seq2) {
        int n = seq2.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        return seq2.getOrdinate(0, 0) == seq2.getOrdinate(n - 1, 0) && seq2.getOrdinate(0, 1) == seq2.getOrdinate(n - 1, 1);
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq2) {
        boolean isClosed;
        int n = seq2.size();
        if (n == 0) {
            return seq2;
        }
        if (n <= 3) {
            return CoordinateSequences.createClosedRing(fact, seq2, 4);
        }
        boolean bl = isClosed = seq2.getOrdinate(0, 0) == seq2.getOrdinate(n - 1, 0) && seq2.getOrdinate(0, 1) == seq2.getOrdinate(n - 1, 1);
        if (isClosed) {
            return seq2;
        }
        return CoordinateSequences.createClosedRing(fact, seq2, n + 1);
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq2, int size) {
        CoordinateSequence newseq = fact.create(size, seq2.getDimension());
        int n = seq2.size();
        CoordinateSequences.copy(seq2, 0, newseq, 0, n);
        for (int i = n; i < size; ++i) {
            CoordinateSequences.copy(seq2, 0, newseq, i, 1);
        }
        return newseq;
    }

    public static CoordinateSequence extend(CoordinateSequenceFactory fact, CoordinateSequence seq2, int size) {
        CoordinateSequence newseq = fact.create(size, seq2.getDimension());
        int n = seq2.size();
        CoordinateSequences.copy(seq2, 0, newseq, 0, n);
        if (n > 0) {
            for (int i = n; i < size; ++i) {
                CoordinateSequences.copy(seq2, n - 1, newseq, i, 1);
            }
        }
        return newseq;
    }

    public static boolean isEqual(CoordinateSequence cs1, CoordinateSequence cs2) {
        int cs2Size;
        int cs1Size = cs1.size();
        if (cs1Size != (cs2Size = cs2.size())) {
            return false;
        }
        int dim = Math.min(cs1.getDimension(), cs2.getDimension());
        for (int i = 0; i < cs1Size; ++i) {
            for (int d = 0; d < dim; ++d) {
                double v1 = cs1.getOrdinate(i, d);
                double v2 = cs2.getOrdinate(i, d);
                if (cs1.getOrdinate(i, d) == cs2.getOrdinate(i, d) || Double.isNaN(v1) && Double.isNaN(v2)) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(CoordinateSequence cs) {
        int size = cs.size();
        if (size == 0) {
            return "()";
        }
        int dim = cs.getDimension();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(" ");
            }
            for (int d = 0; d < dim; ++d) {
                if (d > 0) {
                    builder.append(",");
                }
                builder.append(OrdinateFormat.DEFAULT.format(cs.getOrdinate(i, d)));
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public static Coordinate minCoordinate(CoordinateSequence seq2) {
        Coordinate minCoord = null;
        for (int i = 0; i < seq2.size(); ++i) {
            Coordinate testCoord = seq2.getCoordinate(i);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
        }
        return minCoord;
    }

    public static int minCoordinateIndex(CoordinateSequence seq2) {
        return CoordinateSequences.minCoordinateIndex(seq2, 0, seq2.size() - 1);
    }

    public static int minCoordinateIndex(CoordinateSequence seq2, int from, int to) {
        int minCoordIndex = -1;
        Coordinate minCoord = null;
        for (int i = from; i <= to; ++i) {
            Coordinate testCoord = seq2.getCoordinate(i);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
            minCoordIndex = i;
        }
        return minCoordIndex;
    }

    public static void scroll(CoordinateSequence seq2, Coordinate firstCoordinate) {
        int i = CoordinateSequences.indexOf(firstCoordinate, seq2);
        if (i <= 0) {
            return;
        }
        CoordinateSequences.scroll(seq2, i);
    }

    public static void scroll(CoordinateSequence seq2, int indexOfFirstCoordinate) {
        CoordinateSequences.scroll(seq2, indexOfFirstCoordinate, CoordinateSequences.isRing(seq2));
    }

    public static void scroll(CoordinateSequence seq2, int indexOfFirstCoordinate, boolean ensureRing) {
        int i = indexOfFirstCoordinate;
        if (i <= 0) {
            return;
        }
        CoordinateSequence copy = seq2.copy();
        int last = ensureRing ? seq2.size() - 1 : seq2.size();
        for (int j = 0; j < last; ++j) {
            for (int k = 0; k < seq2.getDimension(); ++k) {
                seq2.setOrdinate(j, k, copy.getOrdinate((indexOfFirstCoordinate + j) % last, k));
            }
        }
        if (ensureRing) {
            for (int k = 0; k < seq2.getDimension(); ++k) {
                seq2.setOrdinate(last, k, seq2.getOrdinate(0, k));
            }
        }
    }

    public static int indexOf(Coordinate coordinate, CoordinateSequence seq2) {
        for (int i = 0; i < seq2.size(); ++i) {
            if (coordinate.x != seq2.getOrdinate(i, 0) || coordinate.y != seq2.getOrdinate(i, 1)) continue;
            return i;
        }
        return -1;
    }
}

