/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.time.Duration;
import java.util.List;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContentFactory;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHandler.class);
    private final ResourceService _resourceService = this.newResourceService();
    private ByteBufferPool _byteBufferPool;
    private Resource _baseResource;
    private Resource _styleSheet;
    private MimeTypes _mimeTypes;
    private List<String> _welcomes = List.of("index.html");
    private boolean _useFileMapping = true;

    public ResourceHandler() {
        this((Handler)null);
    }

    public ResourceHandler(Handler handler) {
        super(handler);
    }

    protected ResourceService newResourceService() {
        return new HandlerResourceService();
    }

    public ResourceService getResourceService() {
        return this._resourceService;
    }

    @Override
    public void doStart() throws Exception {
        Context context2 = ContextHandler.getCurrentContext(this.getServer());
        if (this._baseResource == null) {
            if (context2 != null) {
                this._baseResource = context2.getBaseResource();
            }
        } else if (this._baseResource.isAlias()) {
            LOG.warn("Base Resource should not be an alias");
        }
        this.setMimeTypes(context2 == null ? MimeTypes.DEFAULTS : context2.getMimeTypes());
        this._byteBufferPool = this.getByteBufferPool(context2);
        ResourceService resourceService = this.getResourceService();
        resourceService.setHttpContentFactory(this.newHttpContentFactory());
        resourceService.setWelcomeFactory(this.setupWelcomeFactory());
        if (this.getStyleSheet() == null) {
            this.setStyleSheet(this.getServer().getDefaultStyleSheet());
        }
        super.doStart();
    }

    private ByteBufferPool getByteBufferPool(Context context2) {
        if (context2 == null) {
            return ByteBufferPool.NON_POOLING;
        }
        Server server = this.getServer();
        if (server == null) {
            return ByteBufferPool.NON_POOLING;
        }
        return server.getByteBufferPool();
    }

    public HttpContent.Factory getHttpContentFactory() {
        return this._resourceService.getHttpContentFactory();
    }

    protected HttpContent.Factory newHttpContentFactory() {
        HttpContent.Factory contentFactory = new ResourceHttpContentFactory(this.getBaseResource(), this.getMimeTypes());
        if (this.isUseFileMapping()) {
            contentFactory = new FileMappingHttpContentFactory(contentFactory);
        }
        contentFactory = new VirtualHttpContentFactory(contentFactory, this.getStyleSheet(), "text/css");
        contentFactory = new PreCompressedHttpContentFactory(contentFactory, this.getPrecompressedFormats());
        contentFactory = new ValidatingCachingHttpContentFactory(contentFactory, Duration.ofSeconds(1L).toMillis(), this.getByteBufferPool());
        return contentFactory;
    }

    protected ResourceService.WelcomeFactory setupWelcomeFactory() {
        return (content, request) -> {
            if (this._welcomes == null) {
                return null;
            }
            for (String welcome : this._welcomes) {
                String pathInContext = Request.getPathInContext(request);
                String welcomeInContext = URIUtil.addPaths(pathInContext, welcome);
                Resource welcomePath = content.getResource().resolve(welcome);
                if (!Resources.isReadableFile(welcomePath)) continue;
                return welcomeInContext;
            }
            return null;
        };
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (!HttpMethod.GET.is(request.getMethod()) && !HttpMethod.HEAD.is(request.getMethod())) {
            return super.handle(request, response, callback);
        }
        HttpContent content = this._resourceService.getContent(Request.getPathInContext(request), request);
        if (content == null) {
            return super.handle(request, response, callback);
        }
        this._resourceService.doGet(request, response, callback, content);
        return true;
    }

    public Resource getBaseResource() {
        return this._baseResource;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    public String getCacheControl() {
        return this._resourceService.getCacheControl();
    }

    public List<String> getGzipEquivalentFileExtensions() {
        return this._resourceService.getGzipEquivalentFileExtensions();
    }

    public MimeTypes getMimeTypes() {
        return this._mimeTypes;
    }

    public Resource getStyleSheet() {
        return this._styleSheet == null ? this.getServer().getDefaultStyleSheet() : this._styleSheet;
    }

    public List<String> getWelcomeFiles() {
        return this._welcomes;
    }

    public boolean isAcceptRanges() {
        return this._resourceService.isAcceptRanges();
    }

    public boolean isDirAllowed() {
        return this._resourceService.isDirAllowed();
    }

    public boolean isEtags() {
        return this._resourceService.isEtags();
    }

    public boolean isUseFileMapping() {
        return this._useFileMapping;
    }

    public List<CompressedContentFormat> getPrecompressedFormats() {
        return this._resourceService.getPrecompressedFormats();
    }

    public ResourceService.WelcomeMode getWelcomeMode() {
        return this._resourceService.getWelcomeMode();
    }

    public void setAcceptRanges(boolean acceptRanges) {
        this._resourceService.setAcceptRanges(acceptRanges);
    }

    public void setBaseResource(Resource base) {
        if (this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        this._baseResource = base;
    }

    public void setBaseResourceAsString(String base) {
        this.setBaseResource(base == null ? null : ResourceFactory.of(this).newResource(base));
    }

    public void setCacheControl(String cacheControl) {
        this._resourceService.setCacheControl(cacheControl);
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._resourceService.setDirAllowed(dirAllowed);
    }

    public void setEtags(boolean etags) {
        this._resourceService.setEtags(etags);
    }

    public void setGzipEquivalentFileExtensions(List<String> gzipEquivalentFileExtensions) {
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
    }

    public void setPrecompressedFormats(CompressedContentFormat ... precompressedFormats) {
        this.setPrecompressedFormats(List.of(precompressedFormats));
    }

    public void setPrecompressedFormats(List<CompressedContentFormat> precompressedFormats) {
        this._resourceService.setPrecompressedFormats(precompressedFormats);
    }

    public void setEncodingCacheSize(int encodingCacheSize) {
        this._resourceService.setEncodingCacheSize(encodingCacheSize);
    }

    public int getEncodingCacheSize() {
        return this._resourceService.getEncodingCacheSize();
    }

    public void setMimeTypes(MimeTypes mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setUseFileMapping(boolean useFileMapping) {
        if (this.isRunning()) {
            throw new IllegalStateException("Unable to set useFileMapping on started " + String.valueOf(this));
        }
        this._useFileMapping = useFileMapping;
    }

    public void setWelcomeMode(ResourceService.WelcomeMode welcomeMode) {
        this._resourceService.setWelcomeMode(welcomeMode);
    }

    public void setStyleSheet(Resource styleSheet) {
        this._styleSheet = styleSheet;
    }

    public void setWelcomeFiles(String ... welcomeFiles) {
        this.setWelcomeFiles(List.of(welcomeFiles));
    }

    public void setWelcomeFiles(List<String> welcomeFiles) {
        this._welcomes = welcomeFiles;
    }

    private class HandlerResourceService
    extends ResourceService {
        private HandlerResourceService() {
        }

        @Override
        protected void rehandleWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws Exception {
            HttpURI.Mutable newHttpURI = HttpURI.build(request.getHttpURI()).pathQuery(welcomeTarget);
            Request newRequest = Request.serveAs(request, newHttpURI);
            if (ResourceHandler.this.getServer().handle(newRequest, response, callback)) {
                return;
            }
            super.rehandleWelcome(request, response, callback, welcomeTarget);
        }
    }

    public static class ResourceContext
    extends ContextHandler {
        public ResourceContext() {
            this.setHandler(new ResourceHandler());
        }
    }
}

