/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.text;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.realm.SimpleAccountRealm;
import org.apache.shiro.util.PermissionUtils;

public class TextConfigurationRealm
extends SimpleAccountRealm {
    private volatile String userDefinitions;
    private volatile String roleDefinitions;

    @Override
    protected void onInit() {
        super.onInit();
        this.processDefinitions();
    }

    public String getUserDefinitions() {
        return this.userDefinitions;
    }

    public void setUserDefinitions(String userDefinitions) {
        this.userDefinitions = userDefinitions;
    }

    public String getRoleDefinitions() {
        return this.roleDefinitions;
    }

    public void setRoleDefinitions(String roleDefinitions) {
        this.roleDefinitions = roleDefinitions;
    }

    protected void processDefinitions() {
        try {
            this.processRoleDefinitions();
            this.processUserDefinitions();
        }
        catch (ParseException e2) {
            String msg = "Unable to parse user and/or role definitions.";
            throw new ConfigurationException(msg, e2);
        }
    }

    protected void processRoleDefinitions() throws ParseException {
        String roleDefinitions = this.getRoleDefinitions();
        if (roleDefinitions == null) {
            return;
        }
        Map<String, String> roleDefs = TextConfigurationRealm.toMap(TextConfigurationRealm.toLines(roleDefinitions));
        this.processRoleDefinitions(roleDefs);
    }

    protected void processRoleDefinitions(Map<String, String> roleDefs) {
        if (roleDefs == null || roleDefs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : roleDefs.entrySet()) {
            String rolename = entry.getKey();
            String value = entry.getValue();
            SimpleRole role = this.getRole(rolename);
            if (role == null) {
                role = new SimpleRole(rolename);
                this.add(role);
            }
            Set<Permission> permissions = PermissionUtils.resolveDelimitedPermissions(value, this.getPermissionResolver());
            role.setPermissions(permissions);
        }
    }

    protected void processUserDefinitions() throws ParseException {
        String userDefinitions = this.getUserDefinitions();
        if (userDefinitions == null) {
            return;
        }
        Map<String, String> userDefs = TextConfigurationRealm.toMap(TextConfigurationRealm.toLines(userDefinitions));
        this.processUserDefinitions(userDefs);
    }

    protected void processUserDefinitions(Map<String, String> userDefs) {
        if (userDefs == null || userDefs.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : userDefs.entrySet()) {
            String username = entry.getKey();
            String value = entry.getValue();
            String[] passwordAndRolesArray = StringUtils.split(value);
            String password = passwordAndRolesArray[0];
            SimpleAccount account = this.getUser(username);
            if (account == null) {
                account = new SimpleAccount(username, (Object)password, this.getName());
                this.add(account);
            }
            account.setCredentials(password);
            if (passwordAndRolesArray.length > 1) {
                for (int i = 1; i < passwordAndRolesArray.length; ++i) {
                    String rolename = passwordAndRolesArray[i];
                    account.addRole(rolename);
                    SimpleRole role = this.getRole(rolename);
                    if (role == null) continue;
                    account.addObjectPermissions(role.getPermissions());
                }
                continue;
            }
            account.setRoles(null);
        }
    }

    protected static Set<String> toLines(String s) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try (Scanner scanner = new Scanner(s);){
            while (scanner.hasNextLine()) {
                set.add(scanner.nextLine());
            }
        }
        return set;
    }

    protected static Map<String, String> toMap(Collection<String> keyValuePairs) throws ParseException {
        if (keyValuePairs == null || keyValuePairs.isEmpty()) {
            return null;
        }
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (String pairString : keyValuePairs) {
            String[] pair = StringUtils.splitKeyValue(pairString);
            if (pair == null) continue;
            pairs.put(pair[0].trim(), pair[1].trim());
        }
        return pairs;
    }
}

