/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class FunctionRangeQuery
extends Query {
    private final ValueSource valueSource;
    private final String lowerVal;
    private final String upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public FunctionRangeQuery(ValueSource valueSource, Number lowerVal, Number upperVal, boolean includeLower, boolean includeUpper) {
        this(valueSource, lowerVal == null ? null : lowerVal.toString(), upperVal == null ? null : upperVal.toString(), includeLower, includeUpper);
    }

    public FunctionRangeQuery(ValueSource valueSource, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        this.valueSource = valueSource;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public String getLowerVal() {
        return this.lowerVal;
    }

    public String getUpperVal() {
        return this.upperVal;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    @Override
    public String toString(String field) {
        return "frange(" + this.valueSource + "):" + (this.includeLower ? (char)'[' : '{') + (this.lowerVal == null ? "*" : this.lowerVal) + " TO " + (this.upperVal == null ? "*" : this.upperVal) + (this.includeUpper ? (char)']' : '}');
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((FunctionRangeQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(FunctionRangeQuery other) {
        return this.includeLower == other.includeLower && this.includeUpper == other.includeUpper && Objects.equals(this.valueSource, other.valueSource) && Objects.equals(this.lowerVal, other.lowerVal) && Objects.equals(this.upperVal, other.upperVal);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ Objects.hash(this.valueSource, this.lowerVal, this.upperVal, this.includeLower, this.includeUpper);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new FunctionRangeWeight(searcher);
    }

    private class FunctionRangeWeight
    extends Weight {
        private final Map<Object, Object> vsContext;

        public FunctionRangeWeight(IndexSearcher searcher) throws IOException {
            super(FunctionRangeQuery.this);
            this.vsContext = ValueSource.newContext(searcher);
            FunctionRangeQuery.this.valueSource.createWeight(this.vsContext, searcher);
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            FunctionValues functionValues = FunctionRangeQuery.this.valueSource.getValues(this.vsContext, context2);
            ValueSourceScorer scorer = this.scorer(context2);
            if (scorer.matches(doc)) {
                scorer.iterator().advance(doc);
                return Explanation.match((Number)Float.valueOf(scorer.score()), FunctionRangeQuery.this.toString(), functionValues.explain(doc));
            }
            return Explanation.noMatch(FunctionRangeQuery.this.toString(), functionValues.explain(doc));
        }

        @Override
        public ValueSourceScorer scorer(LeafReaderContext context2) throws IOException {
            FunctionValues functionValues = FunctionRangeQuery.this.valueSource.getValues(this.vsContext, context2);
            return functionValues.getRangeScorer(this, context2, FunctionRangeQuery.this.lowerVal, FunctionRangeQuery.this.upperVal, FunctionRangeQuery.this.includeLower, FunctionRangeQuery.this.includeUpper);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

