/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.resultset.ResultSetPeekable;

public class ResultSetMem
implements ResultSetRewindable,
ResultSetPeekable {
    protected List<Binding> rows = new ArrayList<Binding>();
    protected List<String> varNames = null;
    private int rowNumber = 0;
    private PeekIterator<Binding> iterator = null;
    private Model model = null;

    public ResultSetMem(ResultSetMem imrs2) {
        this(imrs2, false);
    }

    public ResultSetMem(ResultSetMem imrs2, boolean takeCopy) {
        this.varNames = imrs2.varNames;
        if (takeCopy) {
            this.rows.addAll(imrs2.rows);
        } else {
            this.rows = imrs2.rows;
        }
        this.reset();
    }

    public ResultSetMem(ResultSet qr) {
        this.model = qr.getResourceModel();
        if (qr instanceof ResultSetMem) {
            ResultSetMem qrm = (ResultSetMem)qr;
            this.rows = qrm.rows;
            this.varNames = qrm.varNames;
        } else {
            this.varNames = qr.getResultVars();
            List<Var> vars = Var.varList(this.varNames);
            while (qr.hasNext()) {
                Binding rb = BindingFactory.copy(qr.nextBinding());
                this.rows.add(rb);
            }
        }
        this.reset();
    }

    public ResultSetMem() {
        this.varNames = new ArrayList<String>();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public QuerySolution nextSolution() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    @Override
    public Binding nextBinding() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    @Override
    public void forEachRemaining(Consumer<? super QuerySolution> action) {
        this.iterator.forEachRemaining((? super E binding) -> {
            ++this.rowNumber;
            action.accept(new ResultBinding(this.model, (Binding)binding));
        });
    }

    @Override
    public void close() {
    }

    public void rewind() {
        this.reset();
    }

    @Override
    public void reset() {
        this.iterator = new PeekIterator<Binding>(this.rows.iterator());
        this.rowNumber = 0;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public List<String> getResultVars() {
        return this.varNames;
    }

    @Override
    public QuerySolution peek() {
        return new ResultBinding(this.model, this.peekBinding());
    }

    @Override
    public Binding peekBinding() {
        return this.iterator.element();
    }
}

