/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.sys;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.semact.SemanticActionPlugin;
import org.apache.jena.shex.sys.ShexValidatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysShex {
    public static boolean STRICT = true;
    public static String URI = "org.apache.jena.shex";
    public static Logger log = LoggerFactory.getLogger("org.apache.jena.shex.shex");
    public static Node startNode = NodeFactory.createExt("|start|");
    public static Node focusNode = NodeFactory.createExt("|focus|");
    private static Map<String, SemanticActionPlugin> semActPluginIndex = new ConcurrentHashMap<String, SemanticActionPlugin>();
    private static ShexValidator systemValiditor = new ShexValidatorImpl(semActPluginIndex);

    public static void registerSemActPlugin(String uri, SemanticActionPlugin plugin) {
        semActPluginIndex.put(uri, plugin);
    }

    public static void set(ShexValidator validator) {
        systemValiditor = validator;
    }

    public static ShexValidator get() {
        return systemValiditor;
    }

    public static ShexValidator getNew(Collection<SemanticActionPlugin> pz) {
        ConcurrentHashMap<String, SemanticActionPlugin> iriToPlugin = new ConcurrentHashMap<String, SemanticActionPlugin>();
        pz.forEach(p -> p.getUris().forEach(u -> iriToPlugin.put((String)u, (SemanticActionPlugin)p)));
        ShexValidatorImpl ret = new ShexValidatorImpl(iriToPlugin);
        return ret;
    }
}

