/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.langtag.InternalLangTag;
import org.apache.jena.langtag.LangTag;
import org.apache.jena.langtag.LangTagException;
import org.apache.jena.langtag.SysLangTag;

public class LangTags {
    public static LangTag create(String string) {
        return LangTag.of(string);
    }

    public static String format(String string) {
        LangTag langTag = LangTag.of(string);
        return langTag.str();
    }

    public static boolean check(String languageTag) {
        try {
            LangTags.requireValid(languageTag);
            return true;
        }
        catch (LangTagException ex) {
            return false;
        }
    }

    public static void requireValid(String languageTag) {
        LangTag langTag = SysLangTag.create(languageTag);
        if (langTag == null) {
            throw new LangTagException("Invalid lang tag");
        }
    }

    public static String basicFormat(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        List<String> strings = InternalLangTag.splitOnDash(string);
        if (strings == null) {
            InternalLangTag.error("Bad language string: %s", string);
        }
        StringBuilder sb = new StringBuilder(string.length());
        boolean singleton = false;
        boolean first = true;
        for (String s : strings) {
            if (first) {
                sb.append(InternalLangTag.lowercase(s));
                first = false;
                continue;
            }
            first = false;
            sb.append('-');
            if (singleton) {
                sb.append(InternalLangTag.lowercase(s));
                continue;
            }
            sb.append(InternalLangTag.strcase(s));
            if (s.length() != 1) continue;
            singleton = true;
        }
        return sb.toString();
    }

    public static boolean sameLangTagAs(LangTag langTag1, LangTag langTag2) {
        Objects.requireNonNull(langTag1);
        Objects.requireNonNull(langTag2);
        if (langTag1 == langTag2) {
            return true;
        }
        if (!Objects.equals(langTag1.getLanguage(), langTag2.getLanguage())) {
            return false;
        }
        if (!Objects.equals(langTag1.getScript(), langTag2.getScript())) {
            return false;
        }
        if (!Objects.equals(langTag1.getRegion(), langTag2.getRegion())) {
            return false;
        }
        if (!Objects.equals(langTag1.getVariant(), langTag2.getVariant())) {
            return false;
        }
        if (!Objects.equals(langTag1.getExtension(), langTag2.getExtension())) {
            return false;
        }
        return Objects.equals(langTag1.getPrivateUse(), langTag2.getPrivateUse());
    }

    public static boolean basicCheck(String string) {
        try {
            return LangTags.basicCheckEx(string);
        }
        catch (LangTagException ex) {
            return false;
        }
    }

    public static boolean basicCheckEx(String string) {
        boolean start = true;
        int lastSegmentStart = 0;
        boolean firstSegment = true;
        for (int idx = 0; idx < string.length(); ++idx) {
            char ch = string.charAt(idx);
            if (InternalLangTag.isA2ZN(ch)) {
                if (!firstSegment || !InternalLangTag.isNum(ch)) continue;
                InternalLangTag.error("'%s': Number in first subtag", string);
                continue;
            }
            if (ch == '-') {
                if (idx == 0) {
                    InternalLangTag.error("'%s': starts with a '-' character", string);
                    return false;
                }
                firstSegment = false;
                if (idx == lastSegmentStart) {
                    InternalLangTag.error("'%s': two dashes", string);
                    return false;
                }
                lastSegmentStart = idx + 1;
                continue;
            }
            InternalLangTag.error("Bad character: (0x%02X) '%s' index %d", ch, InternalLangTag.str(ch), idx);
            return false;
        }
        if (lastSegmentStart == string.length()) {
            InternalLangTag.error("'%s': Ends in a '-'", string);
            return false;
        }
        return true;
    }

    public static List<String> splitOnDash(String string) {
        try {
            return LangTags.splitOnDashEx(string);
        }
        catch (LangTagException ex) {
            return null;
        }
    }

    public static List<String> splitOnDashEx(String string) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean firstSegment = true;
        boolean start = true;
        for (int idx = 0; idx < string.length(); ++idx) {
            char ch = string.charAt(idx);
            if (InternalLangTag.isA2ZN(ch)) {
                if (firstSegment && InternalLangTag.isNum(ch)) {
                    InternalLangTag.error("'%s': Number in first subtag", string);
                    return null;
                }
                sb.append(ch);
                continue;
            }
            if (ch == '-') {
                if (idx == 0) {
                    InternalLangTag.error("'%s': starts with a '-' character", string);
                    return null;
                }
                firstSegment = false;
                String str2 = sb.toString();
                if (str2.isEmpty()) {
                    InternalLangTag.error("'%s': two dashes", string);
                    return null;
                }
                parts.add(str2);
                sb.setLength(0);
                continue;
            }
            InternalLangTag.error("Bad character: (0x%02X) '%s' index %d", ch, InternalLangTag.str(ch), idx);
            return null;
        }
        String strLast = sb.toString();
        if (strLast.isEmpty()) {
            InternalLangTag.error("'%s': Ends in a '-'", string);
            return null;
        }
        parts.add(strLast);
        return parts;
    }
}

