/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.index;

import java.util.UUID;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.geosparql.implementation.index.GeometryTransformIndex;
import org.apache.jena.geosparql.implementation.index.QueryRewriteIndex;
import org.apache.jena.geosparql.implementation.registry.MathTransformRegistry;
import org.apache.jena.geosparql.implementation.registry.SRSRegistry;

public class IndexConfiguration {
    private static IndexOption indexOptionEnum = IndexOption.MEMORY;

    public static final void setConfig(IndexOption indexOption) {
        indexOptionEnum = indexOption;
        switch (indexOptionEnum) {
            case MEMORY: {
                IndexConfiguration.setupMemoryIndex();
                break;
            }
            default: {
                IndexConfiguration.setupNoIndex();
            }
        }
    }

    private static void setupNoIndex() {
        IndexConfiguration.resetIndexes();
        IndexConfiguration.stopIndexes();
        GeometryLiteralIndex.reset(0, 0L);
        GeometryTransformIndex.reset(0, 0L);
        QueryRewriteIndex.setMaxSize(0);
    }

    private static void setupMemoryIndex() {
        GeometryLiteralIndex.reset(-1, 0L);
        GeometryTransformIndex.reset(-1, 0L);
        QueryRewriteIndex.setMaxSize(-1);
        IndexConfiguration.startIndexes();
    }

    public static void startIndexes() {
        GeometryLiteralIndex.setIndexActive(true);
        GeometryTransformIndex.setIndexActive(true);
    }

    public static void stopIndexes() {
        GeometryLiteralIndex.setIndexActive(false);
        GeometryTransformIndex.setIndexActive(false);
    }

    public static final void resetIndexes() {
        GeometryLiteralIndex.clear();
        GeometryTransformIndex.clear();
    }

    public static final void resetIndexesAndRegistries() {
        GeometryLiteralIndex.clear();
        GeometryTransformIndex.clear();
        SRSRegistry.reset();
        MathTransformRegistry.clear();
    }

    public static final IndexOption getIndexOption() {
        return indexOptionEnum;
    }

    public static final String createURI(String namespaceURI, String prefix) {
        return namespaceURI + prefix + "-" + UUID.randomUUID().toString();
    }

    public static enum IndexOption {
        NONE,
        MEMORY;

    }
}

