/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.geo.topological;

import java.util.Objects;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.geosparql.implementation.vocabulary.Geo;
import org.apache.jena.geosparql.implementation.vocabulary.SpatialExtension;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.system.G;
import org.apache.jena.system.RDFDataException;
import org.apache.jena.vocabulary.RDF;

public class SpatialObjectGeometryLiteral {
    private final Node spatialObject;
    private final Node geometryLiteral;
    private final boolean valid;

    public SpatialObjectGeometryLiteral(Node spatialObject, Node geometryLiteral) {
        this.spatialObject = spatialObject;
        this.geometryLiteral = geometryLiteral;
        this.valid = geometryLiteral != null && spatialObject != null;
    }

    public Node getSpatialObject() {
        return this.spatialObject;
    }

    public Node getGeometryLiteral() {
        return this.geometryLiteral;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.spatialObject);
        hash = 47 * hash + Objects.hashCode(this.geometryLiteral);
        hash = 47 * hash + (this.valid ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialObjectGeometryLiteral other = (SpatialObjectGeometryLiteral)obj;
        if (this.valid != other.valid) {
            return false;
        }
        if (!Objects.equals(this.spatialObject, other.spatialObject)) {
            return false;
        }
        return Objects.equals(this.geometryLiteral, other.geometryLiteral);
    }

    public String toString() {
        return "SpatialObjectGeometryLiteral{spatialObject=" + String.valueOf(this.spatialObject) + ", geometryLiteral=" + String.valueOf(this.geometryLiteral) + ", valid=" + this.valid + "}";
    }

    protected static final SpatialObjectGeometryLiteral retrieve(Graph graph, Node targetSpatialObject) {
        Node geometry = null;
        if (targetSpatialObject != null && targetSpatialObject.isLiteral()) {
            if (targetSpatialObject.getLiteralDatatype() instanceof GeometryDatatype) {
                return new SpatialObjectGeometryLiteral(NodeFactory.createBlankNode(), targetSpatialObject);
            }
            throw new DatatypeFormatException(targetSpatialObject.getLiteralLexicalForm() + " is no Geometry literal");
        }
        if (graph.contains(targetSpatialObject, RDF.type.asNode(), Geo.FEATURE_NODE)) {
            geometry = G.getSP(graph, targetSpatialObject, Geo.HAS_DEFAULT_GEOMETRY_NODE);
        } else if (graph.contains(targetSpatialObject, RDF.type.asNode(), Geo.GEOMETRY_NODE)) {
            geometry = targetSpatialObject;
        }
        if (geometry != null) {
            Node literalNode = G.getSP(graph, geometry, Geo.HAS_SERIALIZATION_NODE);
            if (literalNode == null) {
                literalNode = G.getSP(graph, geometry, Geo.AS_WKT_NODE);
            }
            if (literalNode == null) {
                literalNode = G.getSP(graph, geometry, Geo.AS_GML_NODE);
            }
            if (literalNode != null) {
                return new SpatialObjectGeometryLiteral(targetSpatialObject, literalNode);
            }
        } else if (graph.contains(targetSpatialObject, SpatialExtension.GEO_LAT_NODE, null) && graph.contains(targetSpatialObject, SpatialExtension.GEO_LON_NODE, null)) {
            try {
                Node lat = G.getOneSP(graph, targetSpatialObject, SpatialExtension.GEO_LAT_NODE);
                Node lon = G.getOneSP(graph, targetSpatialObject, SpatialExtension.GEO_LON_NODE);
                Node latLonGeometryLiteral = ConvertLatLon.toNode(lat, lon);
                return new SpatialObjectGeometryLiteral(targetSpatialObject, latLonGeometryLiteral);
            }
            catch (RDFDataException ex) {
                throw new DatatypeFormatException(targetSpatialObject.getURI() + " has more than one geo:lat or geo:lon property.");
            }
        }
        return new SpatialObjectGeometryLiteral(null, null);
    }
}

