/*
 * Decompiled with CFR 0.152.
 */
package tdb2.examples;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.TDB2Factory;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.sys.SystemTDB;
import org.apache.jena.tdb2.sys.TDBInternal;

public class ExQuadFilter {
    private static String graphToHide = "http://example/g2";

    public static void main(String ... args) {
        TDB2.getContext().setTrue(TDB2.symUnionDefaultGraph);
        Dataset ds = ExQuadFilter.setup();
        Predicate<Tuple<NodeId>> filter = ExQuadFilter.createFilter(ds);
        ExQuadFilter.example(ds, filter);
    }

    private static Dataset setup() {
        Dataset ds = TDB2Factory.createDataset();
        DatasetGraph dsg = ds.asDatasetGraph();
        Quad q1 = SSE.parseQuad((String)"(<http://example/g1> <http://example/s> <http://example/p> <http://example/o1>)");
        Quad q2 = SSE.parseQuad((String)"(<http://example/g2> <http://example/s> <http://example/p> <http://example/o2>)");
        dsg.add(q1);
        dsg.add(q2);
        return ds;
    }

    private static Predicate<Tuple<NodeId>> createFilter(Dataset ds) {
        NodeId target = TDBInternal.getNodeId((Dataset)ds, (Node)NodeFactory.createURI((String)graphToHide));
        System.out.println("Hide graph: " + graphToHide + " --> " + String.valueOf(target));
        Predicate<Tuple<NodeId>> filter = item -> item.len() != 4 || !((NodeId)item.get(0)).equals(target);
        return filter;
    }

    private static void example(Dataset ds, Predicate<Tuple<NodeId>> filter) {
        String[] x;
        for (String qs : x = new String[]{"SELECT * { GRAPH ?g { ?s ?p ?o } }", "SELECT * { ?s ?p ?o }", "SELECT * { GRAPH ?g {} }"}) {
            ExQuadFilter.example(ds, qs, filter);
            ExQuadFilter.example(ds, qs, null);
        }
    }

    private static void example(Dataset ds, String qs, Predicate<Tuple<NodeId>> filter) {
        System.out.println();
        Query query = QueryFactory.create((String)qs);
        System.out.println(qs);
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Dataset)ds);){
            if (filter != null) {
                System.out.println("Install quad-level filter");
                qExec.getContext().set(SystemTDB.symTupleFilter, filter);
            } else {
                System.out.println("No quad-level filter");
            }
            ResultSetFormatter.out((ResultSet)qExec.execSelect());
        }
    }
}

