/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.aggregates;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.expr.aggregate.AggCustom;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.sse.SSE;

public class CustomAggregate {
    static AccumulatorFactory myAccumulatorFactory;

    public static void main(String[] args) {
        String aggUri = "http://example/countLiterals";
        AggregateRegistry.register((String)aggUri, (AccumulatorFactory)myAccumulatorFactory, (Node)NodeConst.nodeMinusOne);
        Graph g = SSE.parseGraph((String)"(graph (:s :p :o) (:s :p 1))");
        String qs = "SELECT (<http://example/countLiterals>(?o) AS ?x) {?s ?p ?o}";
        Query q = QueryFactory.create((String)qs);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Model)ModelFactory.createModelForGraph((Graph)g));){
            ResultSet rs = qexec.execSelect();
            ResultSetFormatter.out((ResultSet)rs);
        }
    }

    static {
        LogCtl.setLogging();
        myAccumulatorFactory = new AccumulatorFactory(){

            public Accumulator createAccumulator(AggCustom agg, boolean distinct) {
                return new MyAccumulator(agg);
            }
        };
    }

    static class MyAccumulator
    implements Accumulator {
        int count = 0;
        private AggCustom agg;

        MyAccumulator(AggCustom agg) {
            this.agg = agg;
        }

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ExprList exprList = this.agg.getExprList();
            for (Expr expr : exprList) {
                try {
                    NodeValue nv = expr.eval(binding, functionEnv);
                    if (!nv.isLiteral()) continue;
                    ++this.count;
                }
                catch (ExprEvalException exprEvalException) {}
            }
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger((long)this.count);
        }
    }
}

