/*
 * Decompiled with CFR 0.152.
 */
package tdb2.examples;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.TDB2Factory;

public class ExTDB_Txn1 {
    public static void main(String ... argv) {
        String directory = "MyDatabases/DB1";
        Dataset dataset = TDB2Factory.connectDataset((String)directory);
        Txn.executeRead((Transactional)dataset, () -> {
            String sparqlQueryString1 = "SELECT (count(*) AS ?count) { ?s ?p ?o }";
            ExTDB_Txn1.execQuery(sparqlQueryString1, dataset);
            String sparqlQueryString2 = "SELECT * { ?s ?p ?o }";
            ExTDB_Txn1.execQuery(sparqlQueryString2, dataset);
        });
    }

    public static void execQuery(String sparqlQueryString, Dataset dataset) {
        Query query = QueryFactory.create((String)sparqlQueryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                int count = soln.getLiteral("count").getInt();
                System.out.println("count = " + count);
            }
        }
    }
}

