/*
 * Decompiled with CFR 0.152.
 */
package shex.examples;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shex.ShapeMap;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.sys.ShexLib;

public class Shex01_validateGraph {
    public static void main(String ... args) {
        String SHAPES = "examples/schema.shex";
        String SHAPES_MAP = "examples/shape-map.smap";
        String DATA = "examples/data.ttl";
        System.out.println("Read data");
        Graph dataGraph = RDFDataMgr.loadGraph((String)DATA);
        System.out.println("Read shapes");
        ShexSchema shapes = Shex.readSchema((String)SHAPES);
        System.out.println("Read shapes map");
        ShapeMap shapeMap = Shex.readShapeMap((String)SHAPES_MAP);
        System.out.println("Validate");
        ShexReport report = ShexValidator.get().validate(dataGraph, shapes, shapeMap);
        System.out.println();
        ShexLib.printReport((ShexReport)report);
    }

    static {
        LogCtl.setLogging();
    }
}

