/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.auth;

import arq.examples.ExamplesServer;
import java.net.URI;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;

public class ExAuth00_Setup {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    static FusekiServer server;
    static String serverURL;
    static String dataURL;

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            server = ExamplesServer.startServerWithAuth(dsName, dsg, false, "u", "p");
            serverURL = "http://localhost:" + server.getPort() + "/";
            dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            System.out.println();
            ExAuth00_Setup.exampleAuth();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public static void exampleAuth() {
        System.out.println("No auth");
        ExAuth00_Setup.operation();
        System.out.println("Register user/password (with challenge)");
        AuthEnv.get().registerUsernamePassword(URI.create(dataURL), "u", "p");
        ExAuth00_Setup.operation();
        AuthEnv.get().clearAuthEnv();
        System.out.println("Operation after environment cleared");
        ExAuth00_Setup.operation();
        System.out.println("Register basic auth user/password (without challenge)");
        AuthEnv.get().registerBasicAuthModifier(dataURL, "u", "p");
        ExAuth00_Setup.operation();
        System.out.println("Operation, no basic auth registered");
        AuthEnv.get().clearActiveAuthentication();
        ExAuth00_Setup.operation();
    }

    public static void operation() {
        try (QueryExecution qExec = (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.service((String)dataURL).query("ASK{}")).build();){
            qExec.execAsk();
            System.out.println("Operation succeeded");
        }
        catch (QueryException ex) {
            System.out.println("Operation failed: " + ex.getMessage());
        }
        System.out.println();
    }
}

