/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import java.io.OutputStream;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC;

public class ExQuerySelect2 {
    public static final String NL = System.getProperty("line.separator");

    public static void main(String[] args) {
        Model model = ExQuerySelect2.createModel();
        String prolog = "PREFIX dc: <" + DC.getURI() + ">";
        String queryString = prolog + NL + "SELECT ?title WHERE {?x dc:title ?title}";
        Query query = QueryFactory.create((String)queryString);
        query.serialize(new IndentedWriter((OutputStream)System.out, true));
        System.out.println();
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSetRewindable rewindable = qexec.execSelect().rewindable();
            ResultSetFormatter.out((ResultSet)rewindable);
            rewindable.reset();
            ResultSetFormatter.out((ResultSet)rewindable);
        }
    }

    public static Model createModel() {
        Model m = ModelFactory.createDefaultModel();
        Resource r1 = m.createResource("http://example.org/book#1");
        Resource r2 = m.createResource("http://example.org/book#2");
        r1.addProperty(DC.title, "SPARQL - the book").addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        return m;
    }
}

