/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import java.io.OutputStream;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DC;

public class ExQuerySelect1 {
    public static final String NL = System.getProperty("line.separator");

    public static void main(String[] args) {
        Model model = ExQuerySelect1.createModel();
        String prolog = "PREFIX dc: <" + DC.getURI() + ">";
        String queryString = prolog + NL + "SELECT ?title WHERE {?x dc:title ?title}";
        Query query = QueryFactory.create((String)queryString);
        query.serialize(new IndentedWriter((OutputStream)System.out, true));
        System.out.println();
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);){
            System.out.println("Titles: ");
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution rb = rs.nextSolution();
                RDFNode x = rb.get("title");
                if (x.isLiteral()) {
                    Literal titleStr = (Literal)x;
                    System.out.println("    " + String.valueOf(titleStr));
                    continue;
                }
                System.out.println("Strange - not a literal: " + String.valueOf(x));
            }
        }
    }

    public static Model createModel() {
        Model m = ModelFactory.createDefaultModel();
        Resource r1 = m.createResource("http://example.org/book#1");
        Resource r2 = m.createResource("http://example.org/book#2");
        r1.addProperty(DC.title, "SPARQL - the book").addProperty(DC.description, "A book about SPARQL");
        r2.addProperty(DC.title, "Advanced techniques for SPARQL");
        return m;
    }
}

