/*
 * Decompiled with CFR 0.152.
 */
package tdb1.examples;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb1.TDB1Factory;

public class ExTDB_Txn3 {
    public static void main(String ... argv) {
        DatasetGraph dsg = TDB1Factory.createDatasetGraph();
        Txn.execute((Transactional)dsg, () -> {
            String sparqlQueryString1 = "SELECT (count(*) AS ?count) { ?s ?p ?o }";
            ExTDB_Txn3.execQuery(sparqlQueryString1, dsg);
        });
    }

    public static void execQuery(String sparqlQueryString, DatasetGraph dsg) {
        Dataset dataset = DatasetFactory.wrap((DatasetGraph)dsg);
        Query query = QueryFactory.create((String)sparqlQueryString);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                int count = soln.getLiteral("count").getInt();
                System.out.println("count = " + count);
            }
        }
    }
}

