/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.example.streaming;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.arq.querybuilder.UpdateBuilder;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.vocabulary.RDF;

public class StreamRDFToConnection
implements StreamRDF {
    private RDFConnection connection;
    private int bufferSize = 1000;
    private Set<Quad> quads = new HashSet<Quad>();
    private Model model = ModelFactory.createDefaultModel();

    public StreamRDFToConnection(RDFConnection connection) {
        this.connection = connection;
    }

    public StreamRDFToConnection(RDFConnection connection, int bufferSize) {
        this.connection = connection;
        this.bufferSize = bufferSize;
    }

    private void isBufferFull() {
        if (this.model.size() + (long)this.quads.size() >= (long)this.bufferSize) {
            this.flush();
        }
    }

    private void flush() {
        UpdateBuilder builder = new UpdateBuilder();
        builder.addPrefixes((PrefixMapping)this.model);
        builder.addInsert(this.model);
        builder.addInsertQuads(this.quads);
        this.connection.begin(TxnType.WRITE);
        this.connection.update(builder.build());
        this.connection.commit();
        this.model.removeAll();
        this.quads.clear();
    }

    public void start() {
    }

    public void triple(Triple triple) {
        this.model.add(this.model.asStatement(triple));
        this.isBufferFull();
    }

    public void quad(Quad quad) {
        this.quads.add(quad);
        this.isBufferFull();
    }

    public void base(String base) {
    }

    public void prefix(String prefix, String iri) {
        this.model.setNsPrefix(prefix, iri);
    }

    public void finish() {
        this.flush();
    }

    public static void main(String[] args) {
        Dataset dataset = DatasetFactory.create();
        RDFConnection connection = RDFConnection.connect((Dataset)dataset);
        StreamRDFToConnection stream = new StreamRDFToConnection(connection);
        Resource s = ResourceFactory.createResource((String)"s");
        Property p = ResourceFactory.createProperty((String)"p");
        Literal o = ResourceFactory.createPlainLiteral((String)"OHHHH");
        Resource t = ResourceFactory.createResource((String)"t");
        Resource g = ResourceFactory.createResource((String)"g");
        StatementImpl stmt1 = new StatementImpl(s, p, (RDFNode)o);
        StatementImpl stmt2 = new StatementImpl(s, RDF.type, (RDFNode)t);
        stream.start();
        stream.triple(stmt1.asTriple());
        stream.quad(new Quad(g.asNode(), stmt2.asTriple()));
        stream.finish();
        System.out.println("Contains model 'g': " + dataset.containsNamedModel("g"));
        Model m = dataset.getDefaultModel();
        System.out.println("Default model contains <s,p,o>: " + m.contains((Statement)stmt1));
        m = dataset.getNamedModel("g");
        System.out.println("model 'g' contains <s,RDF.type,t>: " + m.contains((Statement)stmt2));
    }
}

