/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.example;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class Base
implements Runnable {
    public static final String DATA_DIR = "./src/main/resources/data/";
    public static final String ONTOLOGIES_DIR = "./src/main/resources/ontologies/";
    private static Options options;
    private CommandLine commandLine;

    public static void addOption(String opt, String longOpt, boolean hasArg, String description) {
        if (options == null) {
            options = new Options();
        }
        options.addOption(opt, longOpt, hasArg, description);
    }

    public static Options getOptions() {
        if (options == null) {
            options = new Options();
        }
        return options;
    }

    public Base setArgs(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        try {
            this.commandLine = new DefaultParser().parse(Base.getOptions(), args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("", options);
            System.exit(1);
        }
        return this;
    }

    public boolean hasArg(String opt) {
        if (this.commandLine == null) {
            System.err.println("Command line arguments have not been set yet. See setArgs( String[] args )");
            System.exit(1);
        }
        return this.commandLine.hasOption(opt);
    }
}

