/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.propertyfunction;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.vocabulary.RDFS;

public class labelSearch
implements PropertyFunction {
    static int hiddenVariableCount = 0;

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (argSubject.isList() || argObject.isList()) {
            throw new QueryBuildException("List arguments to " + predicate.getURI());
        }
    }

    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Node nodeVar = argSubject.getArg();
        String pattern = NodeUtils.stringLiteral((Node)argObject.getArg());
        if (pattern == null) {
            Log.warn((Object)this, (String)("Pattern must be a plain literal or xsd:string: " + String.valueOf(argObject.getArg())));
            return QueryIterNullIterator.create((ExecutionContext)execCxt);
        }
        Var var2 = labelSearch.createNewVar();
        BasicPattern bp = new BasicPattern();
        Triple t = Triple.create((Node)nodeVar, (Node)RDFS.label.asNode(), (Node)var2);
        bp.add(t);
        OpBGP op = new OpBGP(bp);
        E_Regex regex = new E_Regex((Expr)new ExprVar(var2.getName()), pattern, "i");
        Op filter = OpFilter.filter((Expr)regex, (Op)op);
        Table table = TableFactory.create((QueryIterator)input);
        Op op2 = OpJoin.create((Op)OpTable.create((Table)table), (Op)filter);
        return Algebra.exec((Op)op2, (DatasetGraph)execCxt.getDataset());
    }

    private QueryIterator buildSyntax(QueryIterator input, Node nodeVar, String pattern, ExecutionContext execCxt) {
        Var var2 = labelSearch.createNewVar();
        ElementTriplesBlock elementBGP = new ElementTriplesBlock();
        Triple t = Triple.create((Node)nodeVar, (Node)RDFS.label.asNode(), (Node)var2);
        elementBGP.addTriple(t);
        E_Regex regex = new E_Regex((Expr)new ExprVar(var2.getName()), pattern, "i");
        ElementGroup elementGroup = new ElementGroup();
        elementGroup.addElement((Element)elementBGP);
        elementGroup.addElement((Element)new ElementFilter((Expr)regex));
        Op op = Algebra.compile((Element)elementGroup);
        op = Algebra.optimize((Op)op, (Context)execCxt.getContext());
        return QC.execute((Op)op, (QueryIterator)input, (ExecutionContext)execCxt);
    }

    private static Var createNewVar() {
        String varName = "-search-" + ++hiddenVariableCount;
        return Var.alloc((String)varName);
    }

    public static void main(String[] argv) {
        ResultSet rs;
        String prologue = "PREFIX ext: <java:arq.examples.propertyfunction.>\n";
        String qs = prologue + "SELECT * { ?x ext:labelSearch 'EF' }";
        Query query = QueryFactory.create((String)qs);
        Model model = labelSearch.make();
        try (QueryExecution qExec = QueryExecutionFactory.create((Query)query, (Model)model);){
            rs = qExec.execSelect();
            ResultSetFormatter.out((ResultSet)rs);
        }
        PropertyFunctionRegistry.get().put("http://example/f#search", labelSearch.class);
        prologue = "PREFIX ext: <http://example/f#>\n";
        qs = prologue + "SELECT * { ?x ext:search 'EF' }";
        query = QueryFactory.create((String)qs);
        qExec = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            rs = qExec.execSelect();
            ResultSetFormatter.out((ResultSet)rs);
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
        }
    }

    private static Model make() {
        String BASE = "http://example/";
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("", BASE);
        Resource r1 = model.createResource(BASE + "r1");
        Resource r2 = model.createResource(BASE + "r2");
        r1.addProperty(RDFS.label, "abc");
        r2.addProperty(RDFS.label, "def");
        return model;
    }
}

