/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.constructquads;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.util.PrintUtil;

public class ExampleConstructQuads {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        File[] tests;
        Iterator triples;
        Iterator quads;
        Model model = ModelFactory.createDefaultModel();
        Resource s = model.createResource("http://eg.com/s");
        Property p = model.createProperty("http://eg.com/p");
        Resource o = model.createResource("http://eg.com/o");
        model.add(s, p, (RDFNode)o);
        Dataset dataset = DatasetFactory.create((Model)model);
        Model model1 = ModelFactory.createDefaultModel();
        Resource s1 = model.createResource("http://eg.com/s1");
        Property p1 = model.createProperty("http://eg.com/p1");
        Resource o1 = model.createResource("http://eg.com/o1");
        model1.add(s1, p1, (RDFNode)o1);
        dataset.addNamedModel("http://eg.com/g1", model1);
        PrintUtil.printOut((Iterator)dataset.asDatasetGraph().find());
        System.out.println("construct named graph:");
        String queryString = "CONSTRUCT { GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} } WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        Query query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            quads = qexec.execConstructQuads();
            PrintUtil.printOut((Iterator)quads);
        }
        System.out.println(query);
        System.out.println("construct default graph 1:");
        queryString = "CONSTRUCT {  {<http://eg.com/s1> <http://eg.com/p1> ?o} } WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            quads = qexec.execConstructQuads();
            PrintUtil.printOut((Iterator)quads);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("construct default graph 2:");
        queryString = "CONSTRUCT {<http://eg.com/s1> <http://eg.com/p1> ?o}  WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            quads = qexec.execConstructQuads();
            PrintUtil.printOut((Iterator)quads);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("construct default graph 2:");
        queryString = "CONSTRUCT {<http://eg.com/s1> <http://eg.com/p1> ?o}  WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            triples = qexec.execConstructTriples();
            PrintUtil.printOut((Iterator)triples);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("construct dataset:");
        queryString = "CONSTRUCT { GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} } WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            Dataset d = qexec.execConstructDataset();
            RDFDataMgr.write((OutputStream)System.out, (Dataset)d, (Lang)Lang.TRIG);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("short form 1:");
        queryString = "CONSTRUCT WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            quads = qexec.execConstructQuads();
            PrintUtil.printOut((Iterator)quads);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("short form 2:");
        queryString = "CONSTRUCT WHERE{ <http://eg.com/s> <http://eg.com/p> ?o }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            quads = qexec.execConstructQuads();
            PrintUtil.printOut((Iterator)quads);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("short form 3:");
        queryString = "CONSTRUCT WHERE{ <http://eg.com/s> <http://eg.com/p> ?o }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            triples = qexec.execConstructTriples();
            PrintUtil.printOut((Iterator)triples);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("short form 4:");
        queryString = "CONSTRUCT WHERE{ {<http://eg.com/s> <http://eg.com/p> ?o} }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            quads = qexec.execConstructQuads();
            PrintUtil.printOut((Iterator)quads);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("default graph projection:");
        queryString = "CONSTRUCT { {<http://eg.com/s> <http://eg.com/p> ?o} GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} } WHERE{ GRAPH ?g {<http://eg.com/s1> <http://eg.com/p1> ?o} }";
        query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxARQ);
        qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
        try {
            triples = qexec.execConstructTriples();
            PrintUtil.printOut((Iterator)triples);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        System.out.println(query);
        System.out.println("run-construct-quad-test:");
        for (File test : tests = new File("testing/ARQ/Syntax/Syntax-ARQ").listFiles((dir, fname) -> fname.startsWith("syntax-quad-construct-"))) {
            System.out.println("======== File: " + test.getName());
            try (BufferedReader br = new BufferedReader(new FileReader(test, StandardCharsets.UTF_8));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            System.out.println("==== Output of parse/print file " + test.getName());
            try {
                Query q = QueryFactory.read((String)test.getAbsolutePath(), (Syntax)Syntax.syntaxARQ);
                System.out.println(q);
            }
            catch (QueryParseException ex) {
                System.out.println("File " + test.getAbsolutePath() + " : " + ex.getMessage());
            }
        }
    }
}

