/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.algebra;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class AlgebraExec {
    public static void main(String[] argv) {
        String BASE = "http://example/";
        BasicPattern bp = new BasicPattern();
        Var var_x = Var.alloc((String)"x");
        Var var_z = Var.alloc((String)"z");
        bp.add(Triple.create((Node)var_x, (Node)NodeFactory.createURI((String)(BASE + "p")), (Node)var_z));
        OpBGP op = new OpBGP(bp);
        E_LessThan expr = new E_LessThan((Expr)new ExprVar(var_z), (Expr)NodeValue.makeNodeInteger((long)2L));
        op = OpFilter.filter((Expr)expr, (Op)op);
        Model m = AlgebraExec.makeModel();
        m.write((OutputStream)System.out, "TTL");
        System.out.println("--------------");
        System.out.print(op);
        System.out.println("--------------");
        QueryIterator qIter = Algebra.exec((Op)op, (Graph)m.getGraph());
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("x");
        varNames.add("z");
        ResultSet rs = ResultSetStream.create(varNames, (Model)m, (Iterator)qIter);
        ResultSetFormatter.out((ResultSet)rs);
        qIter.close();
        System.exit(0);
    }

    private static Model makeModel() {
        String BASE = "http://example/";
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("", BASE);
        Resource r1 = model.createResource(BASE + "r1");
        Resource r2 = model.createResource(BASE + "r2");
        Property p1 = model.createProperty(BASE + "p");
        Property p2 = model.createProperty(BASE + "p2");
        Literal v1 = model.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDinteger);
        Literal v2 = model.createTypedLiteral("2", (RDFDatatype)XSDDatatype.XSDinteger);
        r1.addProperty(p1, (RDFNode)v1).addProperty(p1, (RDFNode)v2);
        r1.addProperty(p2, (RDFNode)v1).addProperty(p2, (RDFNode)v2);
        r2.addProperty(p1, (RDFNode)v1).addProperty(p1, (RDFNode)v2);
        return model;
    }
}

