/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.util.function.IntConsumer;

public final class ProcUTF8 {
    public static void convert(int ch, IntConsumer action) {
        if (ch != 0 && ch <= 127) {
            action.accept(ch);
            return;
        }
        if (ch == 0) {
            action.accept(192);
            action.accept(128);
            return;
        }
        if (ch <= 2047) {
            int x1 = ch >> 6 & 0x1F | 0xC0;
            int x2 = ch & 0x3F | 0x80;
            action.accept(x1);
            action.accept(x2);
            return;
        }
        if (ch <= 65535) {
            int x1 = ch >> 12 & 0xF | 0xE0;
            int x2 = ch >> 6 & 0x3F | 0x80;
            int x3 = ch & 0x3F | 0x80;
            action.accept(x1);
            action.accept(x2);
            action.accept(x3);
            return;
        }
        if (ch <= 0x1FFFFF) {
            int x1 = ch >> 18 & 7 | 0xF0;
            ProcUTF8.outputBytes(x1, 4, ch, action);
            return;
        }
        if (ch <= 0x3FFFFFF) {
            int x1 = ch >> 24 & 3 | 0xF8;
            ProcUTF8.outputBytes(x1, 5, ch, action);
            return;
        }
        if (ch <= Integer.MAX_VALUE) {
            int x1 = ch >> 31 & 1 | 0xFC;
            ProcUTF8.outputBytes(x1, 6, ch, action);
            return;
        }
    }

    private static void outputBytes(int x1, int byteLength, int ch, IntConsumer action) {
        action.accept(x1);
        --byteLength;
        for (int i = 0; i < byteLength; ++i) {
            int shift = 6 * (byteLength - i - 1);
            int x = ch >> shift & 0x3F;
            action.accept(x |= 0x80);
        }
    }
}

