/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.CatalogItemImpl;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.CatalogItemHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CatalogItemHandlerTest {
    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/catalogItem-hosting.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        CatalogItem result = (CatalogItem)factory.create((ParseSax.HandlerWithResult)injector.getInstance(CatalogItemHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new CatalogItemImpl("Windows 2008 Datacenter 64 Bit", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"), "Windows 2008 Datacenter 64 Bit", (ReferenceType)new ReferenceTypeImpl("Windows 2008 Datacenter 64 Bit", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2")), (Map)ImmutableSortedMap.of((Comparable)((Object)"Foo"), (Object)"Bar", (Comparable)((Object)"Hello"), (Object)"World")));
    }

    public void testApplyInputStreamWithNamespaceUsingVcloud() {
        InputStream is = this.getClass().getResourceAsStream("/catalogItem-carrenza-with-vcloud-namespace.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        CatalogItem result = (CatalogItem)factory.create((ParseSax.HandlerWithResult)injector.getInstance(CatalogItemHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new CatalogItemImpl("ubuntu10.10x64", URI.create("https://myvdc.carrenza.net/api/v1.0/catalogItem/ecd4d3a0-0d12-4195-a6d2-14cdf9f925a3"), null, (ReferenceType)new ReferenceTypeImpl("ubuntu10.10x64", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://myvdc.carrenza.net/api/v1.0/vAppTemplate/vappTemplate-123766ea-2b55-482c-8adf-735ab1952834")), (Map)ImmutableSortedMap.of()));
    }

    public void testApplyInputStreamWithNamespaceUsingDefault() {
        InputStream is = this.getClass().getResourceAsStream("/catalogItem-carrenza-with-default-namespace.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        CatalogItem result = (CatalogItem)factory.create((ParseSax.HandlerWithResult)injector.getInstance(CatalogItemHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new CatalogItemImpl("ubuntu10.10x64", URI.create("https://myvdc.carrenza.net/api/v1.0/catalogItem/ecd4d3a0-0d12-4195-a6d2-14cdf9f925a3"), null, (ReferenceType)new ReferenceTypeImpl("ubuntu10.10x64", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://myvdc.carrenza.net/api/v1.0/vAppTemplate/vappTemplate-123766ea-2b55-482c-8adf-735ab1952834")), (Map)ImmutableSortedMap.of()));
    }
}

