/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.options;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class InstantiateVAppTemplateOptionsTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});

    @Test
    public void testAddNetworkConfig() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.addNetworkConfig(new NetworkConfig("default", URI.create("http://localhost"), FenceMode.BRIDGED));
        Assert.assertEquals((String)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.BRIDGED);
    }

    @Test
    public void testAddNetworkConfigStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.addNetworkConfig((NetworkConfig)new NetworkConfig("default", URI.create("http://localhost"), FenceMode.BRIDGED));
        Assert.assertEquals((String)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getNetworkName(), (String)"default");
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getParentNetwork(), (Object)URI.create("http://localhost"));
        Assert.assertEquals((Object)((NetworkConfig)Iterables.get((Iterable)options.getNetworkConfig(), (int)0)).getFenceMode(), (Object)FenceMode.BRIDGED);
    }

    @Test
    public void testDescription() {
        InstantiateVAppTemplateOptions options = new InstantiateVAppTemplateOptions();
        options.description("foo");
        Assert.assertEquals((String)options.getDescription(), (String)"foo");
    }

    @Test
    public void testDescriptionStatic() {
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.description((String)"foo");
        Assert.assertEquals((String)options.getDescription(), (String)"foo");
    }
}

