/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.NoSuchElementException;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.features.VDCApi;
import org.jclouds.vcloud.internal.BaseVCloudApiTest;
import org.jclouds.vcloud.xml.VDCHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VDCApiTest")
public class VDCApiTest
extends BaseVCloudApiTest<VDCApi> {
    @Test(expectedExceptions={NoSuchElementException.class})
    public void testFindVDCInOrgNamedBadVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VDCApi.class, (String)"findVDCInOrgNamed", (Class[])new Class[]{String.class, String.class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)"org", (Object)"vdc1"));
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testFindVDCInOrgNamedBadOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VDCApi.class, (String)"findVDCInOrgNamed", (Class[])new Class[]{String.class, String.class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)"org1", (Object)"vdc"));
    }

    public void testFindVDCInOrgNamedNullOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VDCApi.class, (String)"findVDCInOrgNamed", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "vdc"}));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindVDCInOrgNamedNullOrgAndVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VDCApi.class, (String)"findVDCInOrgNamed", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, null}));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VDCApi.class, (String)"getVDC", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

