/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.util;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.domain.VCloudError;
import org.jclouds.vcloud.xml.ErrorHandler;

@Singleton
public class VCloudUtils {
    private final ParseSax.Factory factory;
    private final Provider<ErrorHandler> errorHandlerProvider;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    VCloudUtils(ParseSax.Factory factory, Provider<ErrorHandler> errorHandlerProvider) {
        this.factory = factory;
        this.errorHandlerProvider = errorHandlerProvider;
    }

    public VCloudError parseErrorFromContent(HttpRequest request, HttpResponse response) {
        if (response.getPayload() == null) {
            return null;
        }
        String contentType = response.getPayload().getContentMetadata().getContentType();
        if (contentType != null && contentType.startsWith("application/vnd.vmware.vcloud.error+xml")) {
            try {
                return (VCloudError)this.factory.create((ParseSax.HandlerWithResult)this.errorHandlerProvider.get()).setContext(request).apply(response);
            }
            catch (RuntimeException e) {
                this.logger.warn((Throwable)e, "error parsing error", new Object[0]);
            }
        }
        return null;
    }
}

