/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.util;

import java.net.URI;
import java.util.Map;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudError;
import org.jclouds.vcloud.domain.internal.ErrorImpl;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;

public class Utils {
    public static ReferenceType newReferenceType(Map<String, String> attributes, String defaultType) {
        String uri = attributes.get("href");
        String type = attributes.get("type");
        URI href = uri != null ? URI.create(uri) : null;
        return new ReferenceTypeImpl(attributes.get("name"), type != null ? type : defaultType, href);
    }

    public static ReferenceType newReferenceType(Map<String, String> attributes) {
        return Utils.newReferenceType(attributes, null);
    }

    public static VCloudError newError(Map<String, String> attributes) {
        VCloudError.MinorCode minorErrorCode;
        int errorCode;
        String vendorSpecificErrorCode = attributes.get("vendorSpecificErrorCode");
        try {
            errorCode = Integer.parseInt(attributes.get("majorErrorCode"));
        }
        catch (NumberFormatException e) {
            errorCode = 500;
            vendorSpecificErrorCode = attributes.get("majorErrorCode");
        }
        VCloudError.MinorCode minorCode = minorErrorCode = attributes.containsKey("minorErrorCode") ? VCloudError.MinorCode.fromValue(attributes.get("minorErrorCode")) : null;
        if (minorErrorCode == null || minorErrorCode == VCloudError.MinorCode.UNRECOGNIZED) {
            vendorSpecificErrorCode = attributes.get("minorErrorCode");
        }
        return new ErrorImpl(attributes.get("message"), errorCode, minorErrorCode, vendorSpecificErrorCode, attributes.get("stackTrace"));
    }

    public static void putReferenceType(Map<String, ReferenceType> map, Map<String, String> attributes) {
        map.put(attributes.get("name"), Utils.newReferenceType(attributes));
    }
}

