/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;

public class OrgImpl
extends ReferenceTypeImpl
implements Org {
    private final String fullName;
    @Nullable
    private final String description;
    private final Map<String, ReferenceType> catalogs = Maps.newLinkedHashMap();
    private final Map<String, ReferenceType> vdcs = Maps.newLinkedHashMap();
    private final Map<String, ReferenceType> networks = Maps.newLinkedHashMap();
    private final ReferenceType tasksList;
    private final List<Task> tasks = Lists.newArrayList();

    public OrgImpl(String name, String type, URI id, String fullName, String description, Map<String, ReferenceType> catalogs, Map<String, ReferenceType> vdcs, Map<String, ReferenceType> networks, @Nullable ReferenceType tasksList, Iterable<Task> tasks) {
        super(name, type, id);
        this.fullName = (String)Preconditions.checkNotNull((Object)fullName, (Object)"fullName");
        this.description = description;
        this.catalogs.putAll((Map)Preconditions.checkNotNull(catalogs, (Object)"catalogs"));
        this.vdcs.putAll((Map)Preconditions.checkNotNull(vdcs, (Object)"vdcs"));
        this.networks.putAll((Map)Preconditions.checkNotNull(networks, (Object)"networks"));
        this.tasksList = tasksList;
        Iterables.addAll(this.tasks, (Iterable)((Iterable)Preconditions.checkNotNull(tasks, (Object)"tasks")));
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, ReferenceType> getCatalogs() {
        return this.catalogs;
    }

    @Override
    public Map<String, ReferenceType> getVDCs() {
        return this.vdcs;
    }

    @Override
    public Map<String, ReferenceType> getNetworks() {
        return this.networks;
    }

    @Override
    public ReferenceType getTasksList() {
        return this.tasksList;
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.catalogs == null ? 0 : ((Object)this.catalogs).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        result = 31 * result + (this.networks == null ? 0 : ((Object)this.networks).hashCode());
        result = 31 * result + (this.tasks == null ? 0 : ((Object)this.tasks).hashCode());
        result = 31 * result + (this.tasksList == null ? 0 : this.tasksList.hashCode());
        result = 31 * result + (this.vdcs == null ? 0 : ((Object)this.vdcs).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrgImpl other = (OrgImpl)obj;
        if (this.catalogs == null ? other.catalogs != null : !((Object)this.catalogs).equals(other.catalogs)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
            return false;
        }
        if (this.networks == null ? other.networks != null : !((Object)this.networks).equals(other.networks)) {
            return false;
        }
        if (this.tasks == null ? other.tasks != null : !((Object)this.tasks).equals(other.tasks)) {
            return false;
        }
        if (this.tasksList == null ? other.tasksList != null : !this.tasksList.equals(other.tasksList)) {
            return false;
        }
        return !(this.vdcs == null ? other.vdcs != null : !((Object)this.vdcs).equals(other.vdcs));
    }

    @Override
    public int compareTo(ReferenceType o) {
        return this == o ? 0 : this.getHref().compareTo(o.getHref());
    }

    @Override
    public String toString() {
        return "[href=" + this.getHref() + ", name=" + this.getName() + ", type=" + this.getType() + ", fullName=" + this.fullName + ", description=" + this.description + ", catalogs=" + this.catalogs + ", networks=" + this.networks + ", tasksList=" + this.tasksList + ", vdcs=" + this.vdcs + ", tasks=" + this.tasks + "]";
    }
}

