/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.AllocationModel;
import org.jclouds.vcloud.domain.Capacity;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.VDCStatus;
import org.jclouds.vcloud.domain.internal.VDCImpl;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VDCHandler
extends ParseSax.HandlerWithResult<VDC> {
    protected final TaskHandler taskHandler;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType vDC;
    protected VDCStatus status = VDCStatus.READY;
    protected ReferenceType org;
    protected String description;
    protected List<Task> tasks = Lists.newArrayList();
    protected AllocationModel allocationModel = AllocationModel.UNRECOGNIZED;
    protected Capacity storageCapacity;
    protected Capacity cpuCapacity;
    protected Capacity memoryCapacity;
    protected String units;
    protected long allocated = 0L;
    protected long limit = 0L;
    protected int used = 0;
    protected long overhead = 0L;
    protected Map<String, ReferenceType> resourceEntities = Maps.newLinkedHashMap();
    protected Map<String, ReferenceType> availableNetworks = Maps.newLinkedHashMap();
    protected int nicQuota;
    protected int networkQuota;
    protected int vmQuota;
    protected boolean isEnabled = true;

    @Inject
    public VDCHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    public VDC getResult() {
        return new VDCImpl(this.vDC.getName(), this.vDC.getType(), this.vDC.getHref(), this.status, this.org, this.description, this.tasks, this.allocationModel, this.storageCapacity, this.cpuCapacity, this.memoryCapacity, this.resourceEntities, this.availableNetworks, this.nicQuota, this.networkQuota, this.vmQuota, this.isEnabled);
    }

    void resetCapacity() {
        this.units = null;
        this.allocated = 0L;
        this.limit = 0L;
        this.used = 0;
        this.overhead = 0L;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.endsWith("Vdc")) {
            this.vDC = Utils.newReferenceType(attributes);
            String status = (String)attributes.get("status");
            if (status != null) {
                this.status = VDCStatus.fromValue(Integer.parseInt(status));
            }
        } else if (qName.endsWith("Network")) {
            Utils.putReferenceType(this.availableNetworks, attributes);
        } else if (qName.endsWith("ResourceEntity")) {
            Utils.putReferenceType(this.resourceEntities, attributes);
        } else if (qName.endsWith("Link") && "up".equals(attributes.get("rel"))) {
            this.org = Utils.newReferenceType(attributes);
        } else {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.taskHandler.endElement(uri, name, qName);
        if (qName.endsWith("Task")) {
            this.tasks.add(this.taskHandler.getResult());
        } else if (qName.endsWith("Description")) {
            this.description = this.currentOrNull();
        } else if (qName.endsWith("AllocationModel")) {
            this.allocationModel = AllocationModel.fromValue(this.currentOrNull());
        } else if (qName.endsWith("Units")) {
            this.units = this.currentOrNull();
        } else if (qName.endsWith("Allocated")) {
            this.allocated = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("Used")) {
            this.used = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("Limit")) {
            this.limit = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("Overhead")) {
            this.overhead = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("StorageCapacity")) {
            this.storageCapacity = new Capacity(this.units, this.allocated, this.limit, this.used, this.overhead);
            this.resetCapacity();
        } else if (qName.endsWith("Cpu")) {
            this.cpuCapacity = new Capacity(this.units, this.allocated, this.limit, this.used, this.overhead);
            this.resetCapacity();
        } else if (qName.endsWith("Memory")) {
            this.memoryCapacity = new Capacity(this.units, this.allocated, this.limit, this.used, this.overhead);
            this.resetCapacity();
        } else if (qName.endsWith("DeployedVmsQuota")) {
            this.vmQuota = (int)this.limit;
            if (this.vmQuota == -1) {
                this.vmQuota = 0;
            }
        } else if (qName.endsWith("VmQuota")) {
            this.vmQuota = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("NicQuota")) {
            this.nicQuota = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("NetworkQuota")) {
            this.networkQuota = Integer.parseInt(this.currentOrNull());
        } else if (qName.endsWith("IsEnabled")) {
            this.isEnabled = Boolean.parseBoolean(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

