/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.binders.BindCloneVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.internal.BasePayloadTest;
import org.jclouds.vcloud.options.CloneVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCloneVAppTemplateParamsToXmlPayloadTest
extends BasePayloadTest {
    public void testWithDescription() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/copyVAppTemplate.xml"));
        CloneVAppTemplateOptions options = new CloneVAppTemplateOptions().description("The description of the new vAppTemplate");
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindCloneVAppTemplateParamsToXmlPayload binder = (BindCloneVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindCloneVAppTemplateParamsToXmlPayload.class);
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"name", (Object)"new-linux-server");
        map.put((Object)"Source", (Object)"https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/201");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map.build())).getPayload().getRawContent(), (Object)expected);
    }

    public void testWithDescriptionSourceDelete() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/moveVAppTemplate.xml"));
        CloneVAppTemplateOptions options = new CloneVAppTemplateOptions().description("The description of the new vAppTemplate");
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindCloneVAppTemplateParamsToXmlPayload binder = (BindCloneVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindCloneVAppTemplateParamsToXmlPayload.class);
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"name", (Object)"new-linux-server");
        map.put((Object)"Source", (Object)"https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/201");
        map.put((Object)"IsSourceDelete", (Object)"true");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map.build())).getPayload().getRawContent(), (Object)expected);
    }

    public void testDefault() throws IOException {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/copyVAppTemplate-default.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of());
        BindCloneVAppTemplateParamsToXmlPayload binder = (BindCloneVAppTemplateParamsToXmlPayload)this.injector.getInstance(BindCloneVAppTemplateParamsToXmlPayload.class);
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"name", (Object)"my-vapptemplate");
        map.put((Object)"Source", (Object)"https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/4181");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map.build())).getPayload().getRawContent(), (Object)expected);
    }
}

