/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cim.CIMPredicates;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ovf.OperatingSystemSection;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.VApp;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkAdapter;

public class VCloudComputeUtils {
    public static OperatingSystem toComputeOs(VApp vApp, OperatingSystem defaultOs) {
        CIMOperatingSystem cimOs = VCloudComputeUtils.toComputeOs(vApp);
        return cimOs != null ? cimOs : defaultOs;
    }

    public static CIMOperatingSystem toComputeOs(VApp vApp) {
        return vApp.getChildren().size() > 0 ? VCloudComputeUtils.toComputeOs((Vm)Iterables.get(vApp.getChildren(), (int)0)) : null;
    }

    public static CIMOperatingSystem toComputeOs(Vm vm) {
        return CIMOperatingSystem.toComputeOs((OperatingSystemSection)vm.getOperatingSystemSection());
    }

    public static String getVirtualSystemIdentifierOfFirstVMIn(VApp vApp) {
        return vApp.getChildren().size() > 0 ? VCloudComputeUtils.getVirtualSystemIdentifierOf((Vm)Iterables.get(vApp.getChildren(), (int)0)) : null;
    }

    public static String getVirtualSystemIdentifierOf(Vm vm) {
        if (vm.getVirtualHardwareSection() != null && vm.getVirtualHardwareSection().getSystem() != null) {
            return vm.getVirtualHardwareSection().getSystem().getVirtualSystemIdentifier();
        }
        return null;
    }

    public static LoginCredentials getCredentialsFrom(VApp vApp) {
        return vApp.getChildren().size() > 0 ? VCloudComputeUtils.getCredentialsFrom((Vm)Iterables.get(vApp.getChildren(), (int)0)) : null;
    }

    public static LoginCredentials getCredentialsFrom(VAppTemplate vApp) {
        return vApp.getChildren().size() > 0 ? VCloudComputeUtils.getCredentialsFrom((Vm)Iterables.get(vApp.getChildren(), (int)0)) : null;
    }

    public static LoginCredentials getCredentialsFrom(Vm vm) {
        LoginCredentials.Builder builder = LoginCredentials.builder();
        if (vm.getGuestCustomizationSection() != null) {
            builder.password(vm.getGuestCustomizationSection().getAdminPassword());
        }
        return builder.build();
    }

    public static Set<String> getIpsFromVApp(VApp vApp) {
        if (vApp.getChildren().size() == 0) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder ips = ImmutableSet.builder();
        Vm vm = (Vm)Iterables.get(vApp.getChildren(), (int)0);
        if (vm.getNetworkConnectionSection() != null) {
            for (NetworkConnection connection : vm.getNetworkConnectionSection().getConnections()) {
                if (connection.getIpAddress() != null) {
                    ips.add((Object)connection.getIpAddress());
                }
                if (connection.getExternalIpAddress() == null) continue;
                ips.add((Object)connection.getExternalIpAddress());
            }
        } else {
            for (ResourceAllocationSettingData net : Iterables.filter((Iterable)vm.getVirtualHardwareSection().getItems(), (Predicate)CIMPredicates.resourceTypeIn((ResourceAllocationSettingData.ResourceType[])new ResourceAllocationSettingData.ResourceType[]{ResourceAllocationSettingData.ResourceType.ETHERNET_ADAPTER}))) {
                VCloudNetworkAdapter vNet;
                if (!(net instanceof VCloudNetworkAdapter) || (vNet = (VCloudNetworkAdapter)((Object)VCloudNetworkAdapter.class.cast(net))).getIpAddress() == null) continue;
                ips.add((Object)vNet.getIpAddress());
            }
        }
        return ips.build();
    }
}

