/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;

public class VCloudTemplateOptions
extends TemplateOptions
implements Cloneable {
    private String description = null;
    private String customizationScript = null;
    private IpAddressAllocationMode ipAddressAllocationMode = null;
    private URI parentNetwork = null;
    private FenceMode fenceMode = null;

    public VCloudTemplateOptions clone() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof VCloudTemplateOptions) {
            VCloudTemplateOptions eTo = (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(to);
            if (this.getCustomizationScript() != null) {
                eTo.customizationScript(this.getCustomizationScript());
            }
            if (this.getDescription() != null) {
                eTo.description(this.getDescription());
            }
            if (this.getIpAddressAllocationMode() != null) {
                eTo.ipAddressAllocationMode(this.getIpAddressAllocationMode());
            }
            if (this.getIpAddressAllocationMode() != null) {
                eTo.ipAddressAllocationMode(this.getIpAddressAllocationMode());
            }
            if (this.getParentNetwork() != null) {
                eTo.parentNetwork(this.getParentNetwork());
            }
            if (this.getFenceMode() != null) {
                eTo.fenceMode(this.getFenceMode());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VCloudTemplateOptions that = (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.customizationScript, (Object)that.customizationScript) && Objects.equal((Object)((Object)this.ipAddressAllocationMode), (Object)((Object)that.ipAddressAllocationMode)) && Objects.equal((Object)this.parentNetwork, (Object)that.parentNetwork);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.description, this.customizationScript, this.ipAddressAllocationMode, this.parentNetwork});
    }

    public Objects.ToStringHelper string() {
        return super.string().add("description", (Object)this.description).add("customizationScript", (Object)this.customizationScript).add("ipAddressAllocationMode", (Object)this.ipAddressAllocationMode).add("parentNetwork", (Object)this.parentNetwork);
    }

    public VCloudTemplateOptions description(String description) {
        this.description = description;
        return this;
    }

    public VCloudTemplateOptions customizationScript(String customizationScript) {
        this.customizationScript = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)customizationScript), (Object)"customizationScript must be defined");
        return this;
    }

    public VCloudTemplateOptions ipAddressAllocationMode(IpAddressAllocationMode ipAddressAllocationMode) {
        this.ipAddressAllocationMode = ipAddressAllocationMode;
        return this;
    }

    public VCloudTemplateOptions parentNetwork(URI parentNetwork) {
        this.parentNetwork = parentNetwork;
        return this;
    }

    public VCloudTemplateOptions fenceMode(FenceMode fenceMode) {
        this.fenceMode = fenceMode;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCustomizationScript() {
        return this.customizationScript;
    }

    public IpAddressAllocationMode getIpAddressAllocationMode() {
        return this.ipAddressAllocationMode;
    }

    public URI getParentNetwork() {
        return this.parentNetwork;
    }

    public FenceMode getFenceMode() {
        return this.fenceMode;
    }

    public VCloudTemplateOptions blockOnPort(int port, int seconds) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public VCloudTemplateOptions inboundPorts(int ... ports) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public VCloudTemplateOptions authorizePublicKey(String publicKey) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public VCloudTemplateOptions installPrivateKey(String privateKey) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public VCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public VCloudTemplateOptions userMetadata(String key, String value) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public VCloudTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public VCloudTemplateOptions networks(Iterable<String> networks) {
        return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static VCloudTemplateOptions description(String description) {
            return new VCloudTemplateOptions().description(description);
        }

        public static VCloudTemplateOptions customizationScript(String customizationScript) {
            return new VCloudTemplateOptions().customizationScript(customizationScript);
        }

        public static VCloudTemplateOptions ipAddressAllocationMode(IpAddressAllocationMode ipAddressAllocationMode) {
            return new VCloudTemplateOptions().ipAddressAllocationMode(ipAddressAllocationMode);
        }

        public static VCloudTemplateOptions parentNetwork(URI parentNetwork) {
            return new VCloudTemplateOptions().parentNetwork(parentNetwork);
        }

        public static VCloudTemplateOptions fenceMode(FenceMode fenceMode) {
            return new VCloudTemplateOptions().fenceMode(fenceMode);
        }

        public static VCloudTemplateOptions inboundPorts(int ... ports) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static VCloudTemplateOptions blockOnPort(int port, int seconds) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static VCloudTemplateOptions userMetadata(Map<String, String> userMetadata) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static VCloudTemplateOptions userMetadata(String key, String value) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.userMetadata(key, value));
        }

        public static VCloudTemplateOptions nodeNames(Iterable<String> nodeNames) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static VCloudTemplateOptions networks(Iterable<String> networks) {
            VCloudTemplateOptions options = new VCloudTemplateOptions();
            return (VCloudTemplateOptions)VCloudTemplateOptions.class.cast(options.networks((Iterable)networks));
        }
    }
}

