/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.loaders;

import com.google.common.cache.CacheLoader;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.vcloud.VCloudApi;

@Singleton
public class OVFLoader
extends CacheLoader<URI, Envelope> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final VCloudApi client;

    @Inject
    OVFLoader(VCloudApi client) {
        this.client = client;
    }

    public Envelope load(URI template) {
        return this.client.getVAppTemplateApi().getOvfEnvelopeForVAppTemplate(template);
    }
}

