/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml.ovf;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import org.jclouds.cim.ResourceAllocationSettingData;
import org.jclouds.cim.VirtualSystemSettingData;
import org.jclouds.cim.xml.ResourceAllocationSettingDataHandler;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.ovf.EditableResourceAllocationSettingData;
import org.jclouds.vcloud.domain.ovf.VCloudHardDisk;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkAdapter;
import org.jclouds.vcloud.domain.ovf.VCloudVirtualHardwareSection;
import org.jclouds.vcloud.xml.VCloudVirtualHardwareHandler;
import org.jclouds.vcloud.xml.ovf.VCloudResourceAllocationSettingDataHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VCloudVirtualHardwareSectionHandlerTest")
public class VCloudVirtualHardwareSectionHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                this.bind(ResourceAllocationSettingDataHandler.class).to(VCloudResourceAllocationSettingDataHandler.class);
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testDefault() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/virtualhardwaresection.xml");
        VCloudVirtualHardwareSection result = (VCloudVirtualHardwareSection)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(VCloudVirtualHardwareHandler.class)).parse(is);
        VCloudVirtualHardwareSectionHandlerTest.checkHardware(result);
    }

    @Test(enabled=false)
    public static void checkHardware(VCloudVirtualHardwareSection result) {
        VirtualSystemSettingData system = VirtualSystemSettingData.builder().instanceID("0").elementName("Virtual Hardware Family").virtualSystemIdentifier("RHEL5").virtualSystemType("vmx-07").build();
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/virtualHardwareSection/"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.virtualHardwareSection+xml");
        Assert.assertEquals((String)result.getSystem().toString(), (String)system.toString());
        Assert.assertEquals((String)result.getInfo(), (String)"Virtual hardware requirements");
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)0)).toString(), (String)VCloudNetworkAdapter.builder().instanceID("1").elementName("Network adapter 0").description("PCNet32 ethernet adapter").resourceType(ResourceAllocationSettingData.ResourceType.ETHERNET_ADAPTER).resourceSubType("PCNet32").automaticAllocation(Boolean.valueOf(true)).connection("internet01").address("00:50:56:01:01:f2").addressOnParent("0").ipAddress("174.47.101.164").primaryNetworkConnection(true).ipAddressingMode("POOL").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)1)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("2").elementName("SCSI Controller 0").description("SCSI Controller").resourceType(ResourceAllocationSettingData.ResourceType.PARALLEL_SCSI_HBA).resourceSubType("lsilogic").address("0").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)2)).toString(), (String)VCloudHardDisk.builder().instanceID("2000").elementName("Hard disk 1").description("Hard disk").resourceType(ResourceAllocationSettingData.ResourceType.DISK_DRIVE).addressOnParent("0").parent("2").capacity(30720L).busType(6).busSubType("lsilogic").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)3)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("3").elementName("IDE Controller 0").description("IDE Controller").resourceType(ResourceAllocationSettingData.ResourceType.IDE_CONTROLLER).address("0").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)4)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("3002").elementName("CD/DVD Drive 1").description("CD/DVD Drive").resourceType(ResourceAllocationSettingData.ResourceType.CD_DRIVE).addressOnParent("0").automaticAllocation(Boolean.valueOf(false)).parent("3").build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)5)).toString(), (String)ResourceAllocationSettingData.builder().instanceID("8000").elementName("Floppy Drive 1").description("Floppy Drive").resourceType(ResourceAllocationSettingData.ResourceType.FLOPPY_DRIVE).addressOnParent("0").automaticAllocation(Boolean.valueOf(false)).build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)6)).toString(), (String)EditableResourceAllocationSettingData.builder().instanceID("4").elementName("1 virtual CPU(s)").description("Number of Virtual CPUs").resourceType(ResourceAllocationSettingData.ResourceType.PROCESSOR).virtualQuantity(Long.valueOf(1L)).allocationUnits("hertz * 10^6").reservation(Long.valueOf(0L)).weight(Integer.valueOf(0)).edit((ReferenceType)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.rasdItem+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/virtualHardwareSection/cpu"))).build().toString());
        Assert.assertEquals((String)((ResourceAllocationSettingData)Iterables.get((Iterable)result.getItems(), (int)7)).toString(), (String)EditableResourceAllocationSettingData.builder().instanceID("5").elementName("384 MB of memory").description("Memory Size").resourceType(ResourceAllocationSettingData.ResourceType.MEMORY).virtualQuantity(Long.valueOf(384L)).allocationUnits("byte * 2^20").reservation(Long.valueOf(0L)).weight(Integer.valueOf(0)).edit((ReferenceType)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.rasdItem+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/vm-2087535248/virtualHardwareSection/memory"))).build().toString());
    }
}

