/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.options;

import java.io.IOException;
import java.net.URI;
import org.jclouds.vcloud.compute.options.VCloudTemplateOptions;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VCloudTemplateOptionsTest {
    @Test
    public void testipAddressAllocationMode() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.ipAddressAllocationMode(IpAddressAllocationMode.NONE);
        Assert.assertEquals((Object)options.getIpAddressAllocationMode(), (Object)IpAddressAllocationMode.NONE);
    }

    @Test
    public void testipAddressAllocationModeStatic() {
        VCloudTemplateOptions options = VCloudTemplateOptions.Builder.ipAddressAllocationMode((IpAddressAllocationMode)IpAddressAllocationMode.NONE);
        Assert.assertEquals((Object)options.getIpAddressAllocationMode(), (Object)IpAddressAllocationMode.NONE);
    }

    public void testAs() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        Assert.assertEquals((Object)options.as(VCloudTemplateOptions.class), (Object)options);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="customizationScript must be defined")
    public void testcustomizationScriptBadFormat() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.customizationScript("");
    }

    @Test
    public void testcustomizationScript() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.customizationScript("mykeypair");
        Assert.assertEquals((String)options.getCustomizationScript(), (String)"mykeypair");
    }

    @Test
    public void testcustomizationScriptStatic() {
        VCloudTemplateOptions options = VCloudTemplateOptions.Builder.customizationScript((String)"mykeypair");
        Assert.assertEquals((String)options.getCustomizationScript(), (String)"mykeypair");
    }

    @Test
    public void testNullparentNetwork() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        Assert.assertEquals((Object)options.getParentNetwork(), null);
    }

    @Test
    public void testparentNetwork() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.parentNetwork(URI.create("https://network"));
        Assert.assertEquals((Object)options.getParentNetwork(), (Object)URI.create("https://network"));
    }

    @Test
    public void testparentNetworkStatic() {
        VCloudTemplateOptions options = VCloudTemplateOptions.Builder.parentNetwork((URI)URI.create("https://network"));
        Assert.assertEquals((Object)options.getParentNetwork(), (Object)URI.create("https://network"));
    }

    @Test
    public void testdescription() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.description("mykeypair");
        Assert.assertEquals((String)options.getDescription(), (String)"mykeypair");
    }

    @Test
    public void testdescriptionStatic() {
        VCloudTemplateOptions options = VCloudTemplateOptions.Builder.description((String)"mykeypair");
        Assert.assertEquals((String)options.getDescription(), (String)"mykeypair");
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="customizationScript must be defined")
    public void testcustomizationScriptNPE() {
        VCloudTemplateOptions.Builder.customizationScript(null);
    }

    @Test
    public void testinstallPrivateKey() throws IOException {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.installPrivateKey("-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test
    public void testNullinstallPrivateKey() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        Assert.assertEquals((String)options.getPrivateKey(), null);
    }

    @Test
    public void testauthorizePublicKey() throws IOException {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.authorizePublicKey("ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test
    public void testNullauthorizePublicKey() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        Assert.assertEquals((String)options.getPublicKey(), null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testblockOnPortBadFormat() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.blockOnPort(-1, -1);
    }

    @Test
    public void testblockOnPort() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.blockOnPort(22, 30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test
    public void testNullblockOnPort() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockOnPortStatic() {
        VCloudTemplateOptions options = VCloudTemplateOptions.Builder.blockOnPort((int)22, (int)30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinboundPortsBadFormat() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.inboundPorts(new int[]{-1, -1});
    }

    @Test
    public void testinboundPorts() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        options.inboundPorts(new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testDefaultOpen22() {
        VCloudTemplateOptions options = new VCloudTemplateOptions();
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
    }

    @Test
    public void testinboundPortsStatic() {
        VCloudTemplateOptions options = VCloudTemplateOptions.Builder.inboundPorts((int[])new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }
}

