/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class CatalogItemsInCatalog
implements Function<Catalog, Iterable<CatalogItem>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    CatalogItemsInCatalog(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<CatalogItem> apply(Catalog from) {
        return FutureIterables.transformParallel((Iterable)Iterables.filter(from.values(), (Predicate)new Predicate<ReferenceType>(){

            public boolean apply(ReferenceType input) {
                return input.getType().equals("application/vnd.vmware.vcloud.catalogItem+xml");
            }
        }), (Function)new Function<ReferenceType, ListenableFuture<? extends CatalogItem>>(){

            public ListenableFuture<CatalogItem> apply(ReferenceType from) {
                return CatalogItemsInCatalog.this.aclient.getCatalogClient().getCatalogItem(from.getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)("catalogItems in " + from.getHref()));
    }
}

