/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.sqs.domain.BatchError;
import org.jclouds.sqs.domain.BatchResult;
import org.jclouds.sqs.xml.BatchErrorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BatchResponseHandler<V>
extends ParseSax.HandlerForGeneratedRequestWithResult<BatchResult<V>> {
    private final String resultElement;
    private final ParseSax.HandlerForGeneratedRequestWithResult<Map.Entry<String, V>> resultHandler;
    private final BatchErrorHandler errorHandler;
    private ImmutableMap.Builder<String, V> results = ImmutableMap.builder();
    private ImmutableSet.Builder<BatchError> errors = ImmutableSet.builder();
    private boolean inResult;
    private boolean inError;

    protected BatchResponseHandler(String resultElement, ParseSax.HandlerForGeneratedRequestWithResult<Map.Entry<String, V>> resultHandler, BatchErrorHandler errorHandler) {
        this.resultElement = (String)Preconditions.checkNotNull((Object)resultElement, (Object)"resultElement");
        this.resultHandler = (ParseSax.HandlerForGeneratedRequestWithResult)Preconditions.checkNotNull(resultHandler, (Object)"resultHandler");
        this.errorHandler = (BatchErrorHandler)((Object)Preconditions.checkNotNull((Object)((Object)errorHandler), (Object)"errorHandler"));
    }

    public BatchResult<V> getResult() {
        return BatchResult.builder().putAll(this.results.build()).errors((Iterable<BatchError>)this.errors.build()).build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(this.resultElement)) {
            this.inResult = true;
        } else if (qName.equals("BatchResultErrorEntry")) {
            this.inError = true;
        }
        if (this.inResult) {
            this.resultHandler.startElement(url, name, qName, attributes);
        } else if (this.inError) {
            this.errorHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (qName.equals(this.resultElement)) {
            this.results.put((Map.Entry)this.resultHandler.getResult());
            this.inResult = false;
        } else if (qName.equals("BatchResultErrorEntry")) {
            this.errors.add((Object)this.errorHandler.getResult());
            this.inError = false;
        } else if (this.inResult) {
            this.resultHandler.endElement(uri, name, qName);
        } else if (this.inError) {
            this.errorHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inResult) {
            this.resultHandler.characters(ch, start, length);
        } else if (this.inError) {
            this.errorHandler.characters(ch, start, length);
        }
    }
}

