/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.jclouds.rackspace.clouddns.v1.domain.Record;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;

public class RecordFunctions {
    public static final Function<RecordDetail, String> GET_RECORD_ID = new Function<RecordDetail, String>(){

        public String apply(RecordDetail recordDetail) {
            return recordDetail.getId();
        }
    };
    public static final Function<RecordDetail, Record> GET_RECORD = new Function<RecordDetail, Record>(){

        public Record apply(RecordDetail recordDetail) {
            return recordDetail.getRecord();
        }
    };

    private RecordFunctions() {
    }

    public static Map<String, Record> toRecordMap(Set<RecordDetail> recordDetails) {
        ImmutableMap idsToRecordDetails = Maps.uniqueIndex(recordDetails, GET_RECORD_ID);
        return Maps.transformValues((Map)idsToRecordDetails, GET_RECORD);
    }
}

