/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.filters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.glacier.util.AWSRequestSignerV4;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;

@Singleton
public class RequestAuthorizeSignature
implements HttpRequestFilter {
    private final AWSRequestSignerV4 signer;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;
    private final Provider<String> timeStampProvider;
    private final HttpUtils utils;

    @Inject
    public RequestAuthorizeSignature(@TimeStamp Provider<String> timeStampProvider, @org.jclouds.location.Provider Supplier<Credentials> creds, Crypto crypto, HttpUtils utils) {
        Preconditions.checkNotNull(creds, (Object)"creds");
        this.signer = new AWSRequestSignerV4(((Credentials)creds.get()).identity, ((Credentials)creds.get()).credential, (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto"));
        this.timeStampProvider = (Provider)Preconditions.checkNotNull(timeStampProvider, (Object)"timeStampProvider");
        this.utils = (HttpUtils)Preconditions.checkNotNull((Object)utils, (Object)"utils");
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Date")).replaceHeader("x-amz-date", new String[]{(String)this.timeStampProvider.get()})).replaceHeader("Host", new String[]{request.getEndpoint().getHost()})).build();
        this.utils.logRequest(this.signatureLog, request, ">>");
        request = this.signer.sign(request);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }
}

