/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.BlobImpl;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.blobstore.functions.ArchiveMetadataCollectionToStorageMetadata;
import org.jclouds.glacier.blobstore.functions.ListContainerOptionsToInventoryRetrievalJobRequest;
import org.jclouds.glacier.blobstore.functions.PaginatedVaultCollectionToStorageMetadata;
import org.jclouds.glacier.blobstore.strategy.MultipartUploadStrategy;
import org.jclouds.glacier.blobstore.strategy.PollingStrategy;
import org.jclouds.glacier.domain.ArchiveRetrievalJobRequest;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.util.Predicates2;

@Singleton
public class GlacierBlobStore
extends BaseBlobStore {
    public static final long DEFAULT_INVENTORY_UPDATE_TIME = TimeUnit.HOURS.toMillis(24L);
    @Inject(optional=true)
    @Named(value="jclouds.glacier.inventory.update.time")
    private long inventoryUpdateTime = DEFAULT_INVENTORY_UPDATE_TIME;
    private final GlacierClient sync;
    private final Provider<MultipartUploadStrategy> multipartUploadStrategy;
    private final Provider<PollingStrategy> pollingStrategy;
    private final PaginatedVaultCollectionToStorageMetadata vaultsToContainers;
    private final ArchiveMetadataCollectionToStorageMetadata archivesToBlobs;
    private final ListContainerOptionsToInventoryRetrievalJobRequest containerOptionsToInventoryRetrieval;

    @Inject
    GlacierBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, GlacierClient sync, Provider<MultipartUploadStrategy> multipartUploadStrategy, Provider<PollingStrategy> pollingStrategy, PaginatedVaultCollectionToStorageMetadata vaultsToContainers, ArchiveMetadataCollectionToStorageMetadata archivesToBlobs, ListContainerOptionsToInventoryRetrievalJobRequest containerOptionsToInventoryRetrieval) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.containerOptionsToInventoryRetrieval = (ListContainerOptionsToInventoryRetrievalJobRequest)Preconditions.checkNotNull((Object)containerOptionsToInventoryRetrieval, (Object)"containerOptionsToInventoryRetrieval");
        this.archivesToBlobs = (ArchiveMetadataCollectionToStorageMetadata)Preconditions.checkNotNull((Object)archivesToBlobs, (Object)"archivesToBlobs");
        this.pollingStrategy = (Provider)Preconditions.checkNotNull(pollingStrategy, (Object)"pollingStrategy");
        this.vaultsToContainers = (PaginatedVaultCollectionToStorageMetadata)Preconditions.checkNotNull((Object)vaultsToContainers, (Object)"vaultsToContainers");
        this.multipartUploadStrategy = (Provider)Preconditions.checkNotNull(multipartUploadStrategy, (Object)"multipartUploadStrategy");
        this.sync = (GlacierClient)Preconditions.checkNotNull((Object)sync, (Object)"sync");
    }

    public void deleteContainer(String container) {
        if (!this.sync.deleteVault(container)) {
            this.deletePathAndEnsureGone(container);
        }
    }

    protected void deletePathAndEnsureGone(String container) {
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String container) {
                GlacierBlobStore.this.clearContainer(container);
                return GlacierBlobStore.this.sync.deleteVault(container);
            }
        }, (long)this.inventoryUpdateTime).apply((Object)container), (String)"%s still exists after deleting!", (Object)container);
    }

    protected boolean deleteAndVerifyContainerGone(String container) {
        return this.sync.deleteVault(container);
    }

    public PageSet<? extends StorageMetadata> list() {
        return this.vaultsToContainers.apply(this.sync.listVaults());
    }

    public boolean containerExists(String container) {
        return this.sync.describeVault(container) != null;
    }

    public boolean createContainerInLocation(@Nullable Location location, String container) {
        return this.sync.createVault(container) != null;
    }

    public boolean createContainerInLocation(@Nullable Location location, String container, CreateContainerOptions options) {
        return this.createContainerInLocation(location, container);
    }

    public ContainerAccess getContainerAccess(String container) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setContainerAccess(String container, ContainerAccess access) {
        throw new UnsupportedOperationException("not implemented");
    }

    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions listContainerOptions) {
        String jobId = this.sync.initiateJob(container, this.containerOptionsToInventoryRetrieval.apply(listContainerOptions));
        try {
            if (((PollingStrategy)this.pollingStrategy.get()).waitForSuccess(container, jobId)) {
                return this.archivesToBlobs.apply(this.sync.getInventoryRetrievalOutput(container, jobId));
            }
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
        return null;
    }

    public boolean blobExists(String container, String key) {
        return this.blobMetadata(container, key) != null;
    }

    public String putBlob(String container, Blob blob) {
        return this.sync.uploadArchive(container, blob.getPayload());
    }

    public String putBlob(String container, Blob blob, PutOptions options) {
        if (options.isMultipart()) {
            return ((MultipartUploadStrategy)this.multipartUploadStrategy.get()).execute(container, blob);
        }
        return this.putBlob(container, blob);
    }

    public BlobMetadata blobMetadata(String container, String key) {
        PageSet<? extends StorageMetadata> blobMetadataSet = this.list(container, null);
        for (StorageMetadata blob : blobMetadataSet) {
            if (!blob.getName().equals(key)) continue;
            return (BlobMetadata)blob;
        }
        return null;
    }

    private static ArchiveRetrievalJobRequest buildArchiveRetrievalRequest(String key, GetOptions getOptions) {
        ArchiveRetrievalJobRequest.Builder requestBuilder = ArchiveRetrievalJobRequest.builder().archiveId(key);
        if (getOptions != null) {
            int size = getOptions.getRanges().size();
            Preconditions.checkArgument((size <= 1 ? 1 : 0) != 0, (Object)"The number of ranges should be zero or one");
            if (size == 1) {
                requestBuilder.range(ContentRange.fromString((String)getOptions.getRanges().get(0)));
            }
        }
        return requestBuilder.build();
    }

    public Blob getBlob(String container, String key, GetOptions getOptions) {
        String jobId = this.sync.initiateJob(container, GlacierBlobStore.buildArchiveRetrievalRequest(key, getOptions));
        try {
            if (((PollingStrategy)this.pollingStrategy.get()).waitForSuccess(container, jobId)) {
                MutableBlobMetadataImpl blobMetadata = new MutableBlobMetadataImpl();
                blobMetadata.setContainer(container);
                blobMetadata.setName(key);
                BlobImpl blob = new BlobImpl((MutableBlobMetadata)blobMetadata);
                blob.setPayload(this.sync.getJobOutput(container, jobId));
                return blob;
            }
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
        return null;
    }

    public Blob getBlob(String container, String key) {
        return this.getBlob(container, key, null);
    }

    public void removeBlob(String container, String key) {
        this.sync.deleteArchive(container, key);
    }

    public BlobAccess getBlobAccess(String container, String name) {
        return BlobAccess.PRIVATE;
    }

    public void setBlobAccess(String container, String name, BlobAccess access) {
        throw new UnsupportedOperationException("not implemented");
    }

    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, PutOptions options) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void abortMultipartUpload(MultipartUpload mpu) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<MultipartUpload> listMultipartUploads(String container) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long getMinimumMultipartPartSize() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long getMaximumMultipartPartSize() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int getMaximumNumberOfParts() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

