/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.binders;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.glacier.util.TreeHash;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindMultipartTreeHashToHeaders
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Map), (Object)"This binder is only valid for Map");
        Preconditions.checkNotNull(request, (Object)"request");
        Map map = (Map)Map.class.cast(input);
        Preconditions.checkArgument((map.size() != 0 ? 1 : 0) != 0, (Object)"The map cannot be empty");
        return (R)((HttpRequest.Builder)request.toBuilder().addHeader("x-amz-sha256-tree-hash", new String[]{TreeHash.buildTreeHashFromMap(map).toString()})).build();
    }
}

