/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier;

import com.google.common.hash.HashCode;
import java.io.Closeable;
import java.net.URI;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.glacier.binders.BindArchiveOutputRangeToHeaders;
import org.jclouds.glacier.binders.BindArchiveSizeToHeaders;
import org.jclouds.glacier.binders.BindContentRangeToHeaders;
import org.jclouds.glacier.binders.BindDescriptionToHeaders;
import org.jclouds.glacier.binders.BindHashesToHeaders;
import org.jclouds.glacier.binders.BindJobRequestToJsonPayload;
import org.jclouds.glacier.binders.BindMultipartTreeHashToHeaders;
import org.jclouds.glacier.binders.BindPartSizeToHeaders;
import org.jclouds.glacier.domain.ArchiveMetadataCollection;
import org.jclouds.glacier.domain.JobMetadata;
import org.jclouds.glacier.domain.JobRequest;
import org.jclouds.glacier.domain.MultipartUploadMetadata;
import org.jclouds.glacier.domain.PaginatedJobCollection;
import org.jclouds.glacier.domain.PaginatedMultipartUploadCollection;
import org.jclouds.glacier.domain.PaginatedVaultCollection;
import org.jclouds.glacier.domain.VaultMetadata;
import org.jclouds.glacier.fallbacks.FalseOnIllegalArgumentException;
import org.jclouds.glacier.filters.RequestAuthorizeSignature;
import org.jclouds.glacier.functions.GetPayloadFromHttpContent;
import org.jclouds.glacier.functions.ParseArchiveIdHeader;
import org.jclouds.glacier.functions.ParseArchiveMetadataCollectionFromHttpContent;
import org.jclouds.glacier.functions.ParseJobIdHeader;
import org.jclouds.glacier.functions.ParseJobMetadataFromHttpContent;
import org.jclouds.glacier.functions.ParseJobMetadataListFromHttpContent;
import org.jclouds.glacier.functions.ParseMultipartUploadIdHeader;
import org.jclouds.glacier.functions.ParseMultipartUploadListFromHttpContent;
import org.jclouds.glacier.functions.ParseMultipartUploadPartListFromHttpContent;
import org.jclouds.glacier.functions.ParseMultipartUploadTreeHashHeader;
import org.jclouds.glacier.functions.ParseVaultMetadataFromHttpContent;
import org.jclouds.glacier.functions.ParseVaultMetadataListFromHttpContent;
import org.jclouds.glacier.options.PaginationOptions;
import org.jclouds.glacier.predicates.validators.DescriptionValidator;
import org.jclouds.glacier.predicates.validators.PartSizeValidator;
import org.jclouds.glacier.predicates.validators.PayloadValidator;
import org.jclouds.glacier.predicates.validators.VaultNameValidator;
import org.jclouds.glacier.util.ContentRange;
import org.jclouds.io.Payload;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Headers(keys={"x-amz-glacier-version"}, values={"2012-06-01"})
@RequestFilters(value={RequestAuthorizeSignature.class})
@BlobScope(value=BlobScopes.CONTAINER)
public interface GlacierClient
extends Closeable {
    @Named(value="CreateVault")
    @PUT
    @Path(value="/-/vaults/{vault}")
    public URI createVault(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1);

    @Named(value="DeleteVault")
    @DELETE
    @Path(value="/-/vaults/{vault}")
    @Fallback(value=FalseOnIllegalArgumentException.class)
    public boolean deleteVault(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1);

    @Named(value="DescribeVault")
    @GET
    @Path(value="/-/vaults/{vault}")
    @ResponseParser(value=ParseVaultMetadataFromHttpContent.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public VaultMetadata describeVault(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1);

    @Named(value="ListVaults")
    @GET
    @Path(value="/-/vaults")
    @ResponseParser(value=ParseVaultMetadataListFromHttpContent.class)
    public PaginatedVaultCollection listVaults(PaginationOptions var1);

    @Named(value="ListVaults")
    @GET
    @Path(value="/-/vaults")
    @ResponseParser(value=ParseVaultMetadataListFromHttpContent.class)
    public PaginatedVaultCollection listVaults();

    @Named(value="UploadArchive")
    @POST
    @Path(value="/-/vaults/{vault}/archives")
    @ResponseParser(value=ParseArchiveIdHeader.class)
    public String uploadArchive(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @ParamValidators(value={PayloadValidator.class}) @BinderParam(value=BindHashesToHeaders.class) Payload var2, @ParamValidators(value={DescriptionValidator.class}) @BinderParam(value=BindDescriptionToHeaders.class) String var3);

    @Named(value="UploadArchive")
    @POST
    @Path(value="/-/vaults/{vault}/archives")
    @ResponseParser(value=ParseArchiveIdHeader.class)
    public String uploadArchive(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @ParamValidators(value={PayloadValidator.class}) @BinderParam(value=BindHashesToHeaders.class) Payload var2);

    @Named(value="DeleteArchive")
    @DELETE
    @Path(value="/-/vaults/{vault}/archives/{archive}")
    public boolean deleteArchive(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="archive") String var2);

    @Named(value="InitiateMultipartUpload")
    @POST
    @Path(value="/-/vaults/{vault}/multipart-uploads")
    @ResponseParser(value=ParseMultipartUploadIdHeader.class)
    public String initiateMultipartUpload(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @ParamValidators(value={PartSizeValidator.class}) @BinderParam(value=BindPartSizeToHeaders.class) long var2, @ParamValidators(value={DescriptionValidator.class}) @BinderParam(value=BindDescriptionToHeaders.class) String var4);

    @Named(value="InitiateMultipartUpload")
    @POST
    @Path(value="/-/vaults/{vault}/multipart-uploads")
    @ResponseParser(value=ParseMultipartUploadIdHeader.class)
    public String initiateMultipartUpload(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @ParamValidators(value={PartSizeValidator.class}) @BinderParam(value=BindPartSizeToHeaders.class) long var2);

    @Named(value="UploadPart")
    @PUT
    @Path(value="/-/vaults/{vault}/multipart-uploads/{uploadId}")
    @ResponseParser(value=ParseMultipartUploadTreeHashHeader.class)
    public HashCode uploadPart(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="uploadId") String var2, @BinderParam(value=BindContentRangeToHeaders.class) ContentRange var3, @ParamValidators(value={PayloadValidator.class}) @BinderParam(value=BindHashesToHeaders.class) Payload var4);

    @Named(value="CompleteMultipartUpload")
    @POST
    @Path(value="/-/vaults/{vault}/multipart-uploads/{uploadId}")
    @ResponseParser(value=ParseArchiveIdHeader.class)
    public String completeMultipartUpload(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="uploadId") String var2, @BinderParam(value=BindMultipartTreeHashToHeaders.class) Map<Integer, HashCode> var3, @BinderParam(value=BindArchiveSizeToHeaders.class) long var4);

    @Named(value="AbortMultipartUpload")
    @DELETE
    @Path(value="/-/vaults/{vault}/multipart-uploads/{uploadId}")
    public boolean abortMultipartUpload(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="uploadId") String var2);

    @Named(value="ListParts")
    @GET
    @Path(value="/-/vaults/{vault}/multipart-uploads/{uploadId}")
    @ResponseParser(value=ParseMultipartUploadPartListFromHttpContent.class)
    public MultipartUploadMetadata listParts(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="uploadId") String var2, PaginationOptions var3);

    @Named(value="ListParts")
    @GET
    @Path(value="/-/vaults/{vault}/multipart-uploads/{uploadId}")
    @ResponseParser(value=ParseMultipartUploadPartListFromHttpContent.class)
    public MultipartUploadMetadata listParts(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="uploadId") String var2);

    @Named(value="ListMultipartUploads")
    @GET
    @Path(value="/-/vaults/{vault}/multipart-uploads")
    @ResponseParser(value=ParseMultipartUploadListFromHttpContent.class)
    public PaginatedMultipartUploadCollection listMultipartUploads(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, PaginationOptions var2);

    @Named(value="ListMultipartUploads")
    @GET
    @Path(value="/-/vaults/{vault}/multipart-uploads")
    @ResponseParser(value=ParseMultipartUploadListFromHttpContent.class)
    public PaginatedMultipartUploadCollection listMultipartUploads(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1);

    @Named(value="InitiateJob")
    @POST
    @Path(value="/-/vaults/{vault}/jobs")
    @ResponseParser(value=ParseJobIdHeader.class)
    public String initiateJob(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @BinderParam(value=BindJobRequestToJsonPayload.class) JobRequest var2);

    @Named(value="DescribeJob")
    @GET
    @Path(value="/-/vaults/{vault}/jobs/{job}")
    @ResponseParser(value=ParseJobMetadataFromHttpContent.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public JobMetadata describeJob(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="job") String var2);

    @Named(value="ListJobs")
    @GET
    @Path(value="/-/vaults/{vault}/jobs")
    @ResponseParser(value=ParseJobMetadataListFromHttpContent.class)
    public PaginatedJobCollection listJobs(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, PaginationOptions var2);

    @Named(value="ListJobs")
    @GET
    @Path(value="/-/vaults/{vault}/jobs")
    @ResponseParser(value=ParseJobMetadataListFromHttpContent.class)
    public PaginatedJobCollection listJobs(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1);

    @Named(value="GetJobOutput")
    @GET
    @Path(value="/-/vaults/{vault}/jobs/{job}/output")
    @ResponseParser(value=GetPayloadFromHttpContent.class)
    public Payload getJobOutput(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="job") String var2, @BinderParam(value=BindArchiveOutputRangeToHeaders.class) ContentRange var3);

    @Named(value="GetJobOutput")
    @GET
    @Path(value="/-/vaults/{vault}/jobs/{job}/output")
    @ResponseParser(value=GetPayloadFromHttpContent.class)
    public Payload getJobOutput(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="job") String var2);

    @Named(value="GetInventoryRetrievalOutput")
    @GET
    @Path(value="/-/vaults/{vault}/jobs/{job}/output")
    @ResponseParser(value=ParseArchiveMetadataCollectionFromHttpContent.class)
    public ArchiveMetadataCollection getInventoryRetrievalOutput(@ParamValidators(value={VaultNameValidator.class}) @PathParam(value="vault") String var1, @PathParam(value="job") String var2);
}

