/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

final class MonoSumLong<T>
extends MonoFromFluxOperator<T, Long>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumLong(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Long> s) {
        this.source.subscribe(new SumLongSubscriber<T>(s, this.mapping));
    }

    static final class SumLongSubscriber<T>
    extends MathSubscriber<T, Long> {
        final Function<? super T, ? extends Number> mapping;
        long sum;
        boolean hasValue;

        SumLongSubscriber(CoreSubscriber<? super Long> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            long longValue = this.mapping.apply(newValue).longValue();
            if (this.hasValue) {
                boolean sumPositive = this.sum >= 0L;
                this.sum += longValue;
                if (sumPositive && longValue >= 0L && this.sum < 0L) {
                    this.sum = Long.MAX_VALUE;
                } else if (!sumPositive && longValue < 0L && this.sum > 0L) {
                    this.sum = Long.MIN_VALUE;
                }
            } else {
                this.sum = longValue;
                this.hasValue = true;
            }
        }

        @Override
        protected Long result() {
            return this.hasValue ? Long.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0L;
            this.hasValue = false;
        }
    }
}

