/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.user;

import java.util.concurrent.Callable;
import org.apache.james.cli.user.UserCommand;
import org.apache.james.webadmin.httpclient.UserClient;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a new User"})
public class UserCreateCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    UserCommand userCommand;
    @CommandLine.Option(names={"--force"}, description={"Update a user's password"})
    boolean force;
    @CommandLine.Parameters(description={"Username"})
    String userName;
    @CommandLine.Option(names={"-p", "--password"}, description={"Password"}, arity="0..1", interactive=true, required=true)
    char[] password;

    @Override
    public Integer call() {
        UserClient userClient = this.userCommand.fullyQualifiedURL("/users");
        if (this.force) {
            return this.updateAUserPassword(userClient);
        }
        return this.createAUser(userClient);
    }

    private Integer createAUser(UserClient userClient) {
        try {
            userClient.createAUser(this.userName, new String(this.password));
            this.userCommand.out.println("The user was created successfully");
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.userCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.userCommand.err);
            }
            return 1;
        }
    }

    private Integer updateAUserPassword(UserClient userClient) {
        try {
            userClient.updateAUserPassword(this.userName, new String(this.password));
            this.userCommand.out.println("The user's password was successfully updated");
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.userCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.userCommand.err);
            }
            return 1;
        }
    }
}

