/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.mailbox;

import java.util.concurrent.Callable;
import org.apache.james.cli.mailbox.MailboxCommand;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="deleteAll", description={"Delete all mailboxes of a user"})
public class MailboxDeleteAllCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    MailboxCommand mailboxCommand;
    @CommandLine.Parameters(description={"Username"})
    String userName;

    @Override
    public Integer call() {
        try {
            this.mailboxCommand.fullyQualifiedURL("/users").deleteAllMailboxes(this.userName);
            this.mailboxCommand.out.println("The user do not have mailboxes anymore.");
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.mailboxCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.mailboxCommand.err);
            }
            return 1;
        }
    }
}

