/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.domain;

import java.util.concurrent.Callable;
import org.apache.james.cli.domain.DomainCommand;
import org.apache.james.webadmin.httpclient.DomainClient;
import org.apache.james.webadmin.httpclient.model.DomainAlias;
import picocli.CommandLine;

@CommandLine.Command(name="listAliases", description={"List domain aliases for a given domain"})
public class ListDomainAliasCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    DomainCommand domainCommand;
    @CommandLine.Parameters
    String domainName;

    @Override
    public Integer call() {
        try {
            DomainClient domainClient = this.domainCommand.fullyQualifiedURL("/domains");
            domainClient.getDomainAliasList(this.domainName).stream().map(DomainAlias::getSource).forEach(this.domainCommand.out::println);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(this.domainCommand.err);
            return 1;
        }
    }
}

