/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import javax.net.ssl.SSLEngine;
import org.apache.james.protocols.api.AbstractProtocolTransport;
import org.apache.james.protocols.api.CombinedInputStream;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.netty.LineHandlerUpstreamHandler;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedStream;

public class NettyProtocolTransport
extends AbstractProtocolTransport {
    private final Channel channel;
    private final SSLEngine engine;
    private int lineHandlerCount = 0;

    public NettyProtocolTransport(Channel channel, SSLEngine engine) {
        this.channel = channel;
        this.engine = engine;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    public String getId() {
        return Integer.toString(this.channel.getId());
    }

    public boolean isTLSStarted() {
        return this.channel.getPipeline().get(SslHandler.class) != null;
    }

    public boolean isStartTLSSupported() {
        return this.engine != null;
    }

    public void popLineHandler() {
        if (this.lineHandlerCount > 0) {
            this.channel.getPipeline().remove("lineHandler" + this.lineHandlerCount);
            --this.lineHandlerCount;
        }
    }

    public int getPushedLineHandlerCount() {
        return this.lineHandlerCount;
    }

    private void prepareStartTLS() {
        SslHandler filter = new SslHandler(this.engine, true);
        filter.getEngine().setUseClientMode(false);
        this.channel.getPipeline().addFirst("sslHandler", (ChannelHandler)filter);
    }

    protected void writeToClient(byte[] bytes, ProtocolSession session, boolean startTLS) {
        if (startTLS) {
            this.prepareStartTLS();
        }
        this.channel.write((Object)ChannelBuffers.wrappedBuffer((byte[])bytes));
    }

    protected void close() {
        this.channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
    }

    protected void writeToClient(InputStream in, ProtocolSession session, boolean startTLS) {
        if (startTLS) {
            this.prepareStartTLS();
        }
        if (!this.isTLSStarted()) {
            if (in instanceof FileInputStream) {
                FileChannel fChannel = ((FileInputStream)in).getChannel();
                try {
                    this.channel.write((Object)new DefaultFileRegion(fChannel, 0L, fChannel.size(), true));
                }
                catch (IOException e) {
                    this.channel.write((Object)new ChunkedStream((InputStream)new ExceptionInputStream(e)));
                }
                return;
            }
            if (in instanceof CombinedInputStream) {
                for (InputStream pIn : (CombinedInputStream)in) {
                    if (pIn instanceof FileInputStream) {
                        FileChannel fChannel = ((FileInputStream)in).getChannel();
                        try {
                            this.channel.write((Object)new DefaultFileRegion(fChannel, 0L, fChannel.size(), true));
                            return;
                        }
                        catch (IOException e) {
                            this.channel.write((Object)new ChunkedStream((InputStream)new ExceptionInputStream(e)));
                            continue;
                        }
                    }
                    this.channel.write((Object)new ChunkedStream(in));
                }
                return;
            }
        }
        this.channel.write((Object)new ChunkedStream(in));
    }

    public void setReadable(boolean readable) {
        this.channel.setReadable(readable);
    }

    public boolean isReadable() {
        return this.channel.isReadable();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.getLocalAddress();
    }

    public void pushLineHandler(LineHandler<? extends ProtocolSession> overrideCommandHandler, ProtocolSession session) {
        ++this.lineHandlerCount;
        this.channel.getPipeline().addBefore("coreHandler", "lineHandler" + this.lineHandlerCount, new LineHandlerUpstreamHandler<ProtocolSession>(session, overrideCommandHandler));
    }

    private static final class ExceptionInputStream
    extends InputStream {
        private final IOException e;

        public ExceptionInputStream(IOException e) {
            this.e = e;
        }

        @Override
        public int read() throws IOException {
            throw this.e;
        }
    }
}

