/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.protocols.api.ProtocolConfiguration;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.LineHandler;

public interface ProtocolSession {
    public <T> Optional<T> setAttachment(AttachmentKey<T> var1, T var2, State var3);

    public <T> Optional<T> removeAttachment(AttachmentKey<T> var1, State var2);

    public <T> Optional<T> getAttachment(AttachmentKey<T> var1, State var2);

    @Deprecated
    public Map<AttachmentKey<?>, Object> getState();

    @Deprecated
    public Map<AttachmentKey<?>, Object> getConnectionState();

    public void resetState();

    public InetSocketAddress getRemoteAddress();

    public InetSocketAddress getLocalAddress();

    public String getSessionID();

    public Response newLineTooLongResponse();

    public Response newFatalErrorResponse();

    public Username getUsername();

    public void setUsername(Username var1);

    public boolean isStartTLSSupported();

    public boolean isTLSStarted();

    public ProtocolConfiguration getConfiguration();

    public Charset getCharset();

    public String getLineDelimiter();

    public <T extends ProtocolSession> void pushLineHandler(LineHandler<T> var1);

    public void popLineHandler();

    public int getPushedLineHandlerCount();

    public static class AttachmentKey<T> {
        private final String value;
        private final Class<T> type;

        public static <U> AttachmentKey<U> of(String value, Class<U> type) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)"An attachment key should not be empty or null");
            return new AttachmentKey<U>(value, type);
        }

        private AttachmentKey(String value, Class<T> type) {
            this.value = value;
            this.type = type;
        }

        public String asString() {
            return this.value;
        }

        public Optional<T> convert(Object object) {
            return Optional.ofNullable(object).filter(this.type::isInstance).map(this.type::cast);
        }

        public final boolean equals(Object o) {
            if (o instanceof AttachmentKey) {
                AttachmentKey that = (AttachmentKey)o;
                return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value, this.type);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("type", (Object)this.type.getName()).toString();
        }
    }

    public static enum State {
        Connection,
        Transaction;

    }
}

