/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.james.mpt.Runner;
import org.apache.james.mpt.api.ImapFeatures;
import org.apache.james.mpt.api.Monitor;
import org.apache.james.mpt.api.SessionFactory;
import org.apache.james.mpt.host.ExternalHostSystem;
import org.apache.james.mpt.maven.AddUser;
import org.apache.james.mpt.protocol.ProtocolSessionBuilder;
import org.apache.james.mpt.user.ScriptedUserAdder;
import org.apache.james.util.Port;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class MailProtocolTest
implements Monitor {
    private static final ImapFeatures SUPPORTED_FEATURES = ImapFeatures.of((ImapFeatures.Feature[])new ImapFeatures.Feature[]{ImapFeatures.Feature.NAMESPACE_SUPPORT});
    private Integer port;
    private File scriptFile;
    private String host;
    private String shabang;
    private AddUser[] addUsers;

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setShabang(String shabang) {
        this.shabang = shabang;
    }

    public void setAddUser(AddUser[] addUsers) {
        this.addUsers = addUsers;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validate();
        for (AddUser addUser : this.addUsers) {
            try {
                Reader reader = addUser.getScriptText() != null ? new StringReader(addUser.getScriptText()) : new FileReader(addUser.getScriptFile());
                ScriptedUserAdder adder = new ScriptedUserAdder(addUser.getHost(), addUser.getPort().orElseThrow(() -> new RuntimeException("Port should be set")), (Monitor)this);
                adder.addUser(addUser.getUser(), addUser.getPasswd(), reader);
            }
            catch (Exception e) {
                throw new MojoFailureException("User addition failed: \n" + e.getMessage());
            }
        }
        Runner runner = new Runner();
        try {
            FileInputStream inputStream = new FileInputStream(this.scriptFile);
            ExternalHostSystem hostSystem = new ExternalHostSystem(SUPPORTED_FEATURES, this.host, new Port(this.port.intValue()), (Monitor)this, this.shabang, null);
            ProtocolSessionBuilder builder = new ProtocolSessionBuilder();
            builder.addProtocolLines(this.scriptFile.getName(), (InputStream)inputStream, runner.getTestElements());
            runner.runSessions((SessionFactory)hostSystem);
        }
        catch (IOException e1) {
            throw new MojoExecutionException("Cannot load script " + this.scriptFile.getName(), (Exception)e1);
        }
        catch (Exception e) {
            throw new MojoExecutionException("[FAILURE] in script " + this.scriptFile.getName() + "\n" + e.getMessage(), e);
        }
    }

    private void validate() throws MojoFailureException {
        if (this.port <= 0) {
            throw new MojoFailureException("'port' configuration must be set.");
        }
        if (!this.scriptFile.exists()) {
            throw new MojoFailureException("'scriptFile' not exists");
        }
        for (AddUser addUser : this.addUsers) {
            if (addUser.getScriptText() == null && addUser.getScriptFile() == null) {
                throw new MojoFailureException("AddUser must contain the text of the script or a scriptFile");
            }
            if (!addUser.getPort().isPresent()) {
                throw new MojoFailureException("'port' attribute must be set on AddUser to the port against which the script should run.");
            }
            if (addUser.getHost() != null) continue;
            throw new MojoFailureException("'host' attribute must be set on AddUser to the host against which the script should run.");
        }
    }

    public void debug(char character) {
    }

    public void debug(String message) {
    }

    public void note(String message) {
        System.out.println(message);
    }
}

